/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class FiscalPeriodsPane
extends JEditorPane
implements HyperlinkListener,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FiscalPeriodsPane.class);
    protected HomeView view;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    private static Color redBackground = new Color(255, 238, 238);
    private static Color greenBackground = new Color(238, 255, 238);

    public FiscalPeriodsPane(HomeView view) {
        this.view = view;
        this.fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
        this.fiscalPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.setOpaque(true);
        this.setContentType("text/html");
        this.setEditable(false);
        this.setUI(new BasicEditorPaneUI());
        this.addHyperlinkListener(this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getDescription().equals("#fiscalperiodschart")) {
            MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showFiscalPeriodView((JAXXContext)ui);
        }
    }

    public void refresh() {
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        try {
            List fiscalPeriods = this.fiscalPeriodService.getAllFiscalPeriods();
            List unblockedFiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
            if (unblockedFiscalPeriods.size() > 0) {
                this.setBackground(greenBackground);
                String fiscalString = unblockedFiscalPeriods.size() + " " + I18n._((String)"lima.home.fiscalperiod.opened") + "<br/>" + (fiscalPeriods.size() - unblockedFiscalPeriods.size()) + " " + I18n._((String)"lima.home.fiscalperiod.closed") + "<br/><br/><a href='#fiscalperiodschart'>" + I18n._((String)"lima.home.fiscalperiod.modify") + "</a>";
                this.setText(htmlBegin + fiscalString + htmlEnd);
            } else {
                this.setBackground(redBackground);
                String fiscalString = I18n._((String)"lima.home.fiscalperiod.noopen");
                if (fiscalPeriods.size() > 0) {
                    fiscalString = fiscalString + "<br/>" + fiscalPeriods.size() + " " + I18n._((String)"lima.home.fiscalperiod.closed");
                }
                fiscalString = fiscalString + "<br/><br/><a href='#fiscalperiodschart'>" + I18n._((String)"lima.home.fiscalperiod.create") + "</a>";
                this.setText(htmlBegin + fiscalString + htmlEnd);
            }
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't get datas home", (Throwable)eee);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("FiscalPeriod") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

