/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.account;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.AccountImpl;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.account.AccountForm;
import org.chorem.lima.ui.account.AccountImportForm;
import org.chorem.lima.ui.account.AccountTreeTableModel;
import org.chorem.lima.ui.account.AccountView;
import org.chorem.lima.ui.account.SubLedgerForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;

public class AccountViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(AccountViewHandler.class);
    protected AccountView view;

    protected AccountViewHandler(AccountView view) {
        this.view = view;
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void addAccount() {
        JXTreeTable accountsTreeTable = this.view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel = (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
        AccountImpl newAccount = new AccountImpl();
        AccountForm accountForm = new AccountForm((JAXXContext)this.view);
        accountForm.setAccount((Account)newAccount);
        accountForm.setLocationRelativeTo((Component)((Object)this.view));
        accountForm.setVisible(true);
        newAccount = accountForm.getAccount();
        if (newAccount != null) {
            TreePath treePath = null;
            int selectedRow = this.view.getAccountsTreeTable().getSelectedRow();
            treePath = selectedRow != -1 ? this.view.getAccountsTreeTable().getPathForRow(selectedRow) : new TreePath(accountsTreeTableModel.getRoot());
            try {
                accountsTreeTableModel.addAccount(treePath, (Account)newAccount);
            }
            catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add account", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            catch (LimaException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add account", (Throwable)ex);
                }
                ErrorHelper.showErrorDialog("Can't add account", ex);
            }
        }
    }

    public void addSubLedger() {
        JXTreeTable accountsTreeTable = this.view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel = (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
        AccountImpl newAccount = new AccountImpl();
        SubLedgerForm subledgerForm = new SubLedgerForm((JAXXContext)this.view);
        subledgerForm.setAccount((Account)newAccount);
        subledgerForm.setLocationRelativeTo((Component)((Object)this.view));
        subledgerForm.setVisible(true);
        newAccount = subledgerForm.getAccount();
        if (newAccount != null) {
            TreePath treePath = null;
            int selectedRow = this.view.getAccountsTreeTable().getSelectedRow();
            treePath = this.view.getAccountsTreeTable().getPathForRow(selectedRow);
            try {
                accountsTreeTableModel.addSubLedger(treePath, (Account)newAccount);
            }
            catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add subledger", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add subledger", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    public void updateAccount() {
        JXTreeTable accountsTreeTable = this.view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel = (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
        int selectedRow = this.view.getAccountsTreeTable().getSelectedRow();
        TreePath treePath = this.view.getAccountsTreeTable().getPathForRow(selectedRow);
        Account selectedObject = (Account)treePath.getLastPathComponent();
        if (selectedObject != null) {
            treePath = selectedRow != -1 ? this.view.getAccountsTreeTable().getPathForRow(selectedRow) : new TreePath(accountsTreeTableModel.getRoot());
            if (selectedObject.getGeneralLedger() == null) {
                AccountForm accountForm = new AccountForm((JAXXContext)this.view);
                accountForm.setAccount(selectedObject);
                accountForm.setLocationRelativeTo((Component)((Object)this.view));
                accountForm.setVisible(true);
                selectedObject = accountForm.getAccount();
            } else {
                SubLedgerForm subLedgerForm = new SubLedgerForm((JAXXContext)this.view);
                subLedgerForm.setAccount(selectedObject);
                subLedgerForm.setLocationRelativeTo((Component)((Object)this.view));
                subLedgerForm.setVisible(true);
                selectedObject = subLedgerForm.getAccount();
            }
            if (selectedObject != null) {
                try {
                    accountsTreeTableModel.updateAccount(treePath, selectedObject);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't add update", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void removeAccount() {
        int n;
        JXTreeTable accountsTreeTable = this.view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel = (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
        int selectedRow = this.view.getAccountsTreeTable().getSelectedRow();
        if (selectedRow != -1 && (n = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.charts.account.question.remove"), I18n._((String)"lima.common.question"), 0, 3)) == 0) {
            TreePath treePath = this.view.getAccountsTreeTable().getPathForRow(selectedRow);
            Account account = (Account)treePath.getLastPathComponent();
            try {
                accountsTreeTableModel.removeAccount(treePath, account);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't delete account", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    public void refresh() {
        block2: {
            JXTreeTable accountsTreeTable = this.view.getAccountsTreeTable();
            AccountTreeTableModel accountsTreeTableModel = (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
            try {
                accountsTreeTableModel.refreshTree();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't refresh model", (Throwable)eee);
            }
        }
        this.view.repaint();
    }

    public void importAccountsChart() {
        AccountImportForm form = new AccountImportForm();
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        ImportExport importExport = ImportExport.getInstance((Component)((Object)this.view));
        Object value = form.getRadioButtons().getSelectedValue();
        if (value != null) {
            AccountsChartEnum defaultAccountsChartEnum = (AccountsChartEnum)((Object)value);
            switch (defaultAccountsChartEnum) {
                case IMPORTEBP: {
                    importExport.importExport(ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT, defaultAccountsChartEnum.getFilePath(), false);
                    break;
                }
                default: {
                    importExport.importExport(ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT, defaultAccountsChartEnum.getFilePath(), false);
                }
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importAccounts") || methodeName.contains("importAll") || methodeName.contains("importAsCSV")) {
            this.refresh();
        }
    }
}

