/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import java.beans.PropertyChangeListener;
import java.util.Locale;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.actions.MiscAction;
import org.chorem.lima.entity.LimaCallaoDAOHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;
import org.nuiton.util.converter.ConverterUtil;

public class LimaConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(LimaConfig.class);
    protected static LimaConfig instance;
    private static final String configFile = "lima-config.properties";
    protected Version version;
    public static final String[] DEFAULT_JAXX_PCS;

    public String getCopyrightText() {
        return "Version " + this.getVersion() + " Codelutin @ 2008-2010";
    }

    public String getVersion() {
        return this.version.toString();
    }

    public LimaConfig() {
        for (Option option : Option.values()) {
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : Action.values()) {
            for (String alias : ((Action)enum_).aliases) {
                this.addActionAlias(alias, ((Action)enum_).action);
            }
        }
        this.addAlias("--disableui", new String[]{"--launchui false"});
    }

    public static LimaConfig getInstance() {
        if (instance == null) {
            instance = new LimaConfig();
            instance.loadConfiguration(configFile);
        }
        return instance;
    }

    protected void loadConfiguration(String configFileName) {
        block2: {
            instance.setConfigFileName(configFileName);
            try {
                instance.parse(new String[0]);
            }
            catch (ArgumentsParserException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't read configuration", (Throwable)ex);
            }
        }
        instance.setOption("topia.persistence.classes", LimaCallaoDAOHelper.getImplementationClassesAsString());
    }

    public void parse(String[] args) throws ArgumentsParserException {
        super.parse(args);
        String sVersion = VersionUtil.removeSnapshot((String)this.getOption("application.version"));
        this.version = VersionUtil.valueOf((String)sVersion);
    }

    public Locale getLocale() {
        String local = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConverterUtil.convert(Locale.class, (Object)local);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public void setLocale(Locale newLocale) {
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.saveForUser(new String[0]);
        this.firePropertyChange("locale", null, newLocale);
    }

    public boolean isLaunchui() {
        boolean launchUI = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return launchUI;
    }

    public void setLaunchui(String launchui) {
        this.setOption(Option.LAUNCH_UI.key, launchui);
    }

    public void setFullscreen(boolean fullscreen) {
        boolean oldValue = this.isFullScreen();
        this.setOption(Option.FULL_SCREEN.key, fullscreen + "");
        this.saveForUser(new String[0]);
        this.firePropertyChange("fullscreen", oldValue, fullscreen);
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public String getSupportEmail() {
        return this.getOption(Option.SUPPORT_EMAIL.key);
    }

    public boolean isEJBRemoteMode() {
        boolean result = this.getOptionAsBoolean(Option.OPENEJB_REMOTEMODE.key);
        return result;
    }

    public String getHostAdress() {
        return this.getOption(Option.LIMA_HOST_ADDRESS.key);
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = JAXXUtil.findJaxxPropertyChangeListener((String[])DEFAULT_JAXX_PCS, (PropertyChangeListener[])this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    static {
        DEFAULT_JAXX_PCS = new String[]{"fullScreen", "locale"};
    }

    public static enum Action {
        HELP(I18n._((String)"lima.action.commandline.help"), MiscAction.class.getName() + "#help", "-h", "--help");

        public static final int BEFORE_EXIT_STEP = 0;
        public static final int AFTER_INIT_STEP = 1;
        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"lima.config.configFileName.description"), "lima-config.properties", String.class, true, true),
        LOCALE("locale", I18n._((String)"lima.config.locale.description"), "fr_FR", Locale.class, false, false),
        FULL_SCREEN("lima.ui.fullscreen", I18n._((String)"lima.config.ui.fullscreen.description"), "false", Boolean.class, false, false),
        LAUNCH_UI("lima.ui.launchui", I18n._((String)"lima.config.ui.flaunchui.description"), "true", Boolean.class, true, true),
        SUPPORT_EMAIL("lima.misc.supportemail", I18n._((String)"lima.misc.supportemail.description"), "", String.class, false, false),
        OPENEJB_REMOTEMODE("lima.openejb.remotemode", I18n._((String)"lima.openejb.remotemode.description"), "false", String.class, false, false),
        LIMA_HOST_ADDRESS("lima.host.address", I18n._((String)"lima.config.host.adress"), "localhost", String.class, false, false);

        public final String key;
        public final String description;
        public String defaultValue;
        public final Class<?> type;
        public boolean _transient;
        public boolean _final;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        public boolean isFinal() {
            return this._final;
        }

        public void setFinal(boolean _final) {
            this._final = _final;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void setTransient(boolean _transient) {
            this._transient = _transient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

