/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodViewHandler.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.fiscalperiod;

import static org.nuiton.i18n.I18n._;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.util.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.fiscalperiod.AddPeriod;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.util.DialogHelper;

/**
 * TODO add comment here.
 * 
 * @author chatellier
 * @version $Revision: 3051 $
 * 
 * Last update : $Date: 2010-11-29 15:57:16 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class FiscalPeriodViewHandler {

    private static final Log log = LogFactory.getLog(FiscalPeriodViewHandler.class);
    
    private FiscalPeriodView view;
    
    protected FiscalPeriodViewHandler(FiscalPeriodView view) {
        this.view=view;
    }

    public void addFiscalPeriod() {
        
        FiscalPeriodTableModel model =
            (FiscalPeriodTableModel)getView().getFiscalPeriodTable().getModel();
        
        AddPeriod addPeriodDialog = new AddPeriod(getView());
        // jaxx don't call super() ?
        addPeriodDialog.setLocationRelativeTo(getView());
        addPeriodDialog.setVisible(true);
        
        FiscalPeriod fiscalPeriod = addPeriodDialog.getPeriod();
        // null = cancel
        if (fiscalPeriod!= null) {
            //check if fiscalperiod have 12 months, ask a confirmation
            int nbMonth =
                DateUtils.getDifferenceInMonths(fiscalPeriod.getBeginDate(),
                        fiscalPeriod.getEndDate());
            int n = 0;
            if(nbMonth !=12){
                n = JOptionPane.showConfirmDialog(getView(),
                        _("lima.charts.fiscalperiod.question.morethan12"),
                        _("lima.common.question"),
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE);
            }
            if (n == JOptionPane.YES_OPTION || nbMonth ==11){
                try {
                    model.addFiscalPeriod(fiscalPeriod);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't add fiscal period", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void blockFiscalPeriod() {
        JXTable fiscalPeriodeTable = getView().getFiscalPeriodTable();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriodTableModel model =
            (FiscalPeriodTableModel)getView().getFiscalPeriodTable().getModel();
        
        // blocked it
        try {
            FiscalPeriod selectedFiscalPeriod =
                model.getFiscalPeriodAtRow(selectedRow);
            int response =
                JOptionPane.showConfirmDialog(getView(),
                        _("lima.charts.fiscalperiod.question.blocked"),
                        _("lima.common.question"), JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE);

            if (response == JOptionPane.YES_OPTION) {
                model.blockFiscalPeriod(selectedFiscalPeriod);
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't block fiscalperiod", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }   

    public FiscalPeriodView getView() {
        return view;
    }
}
