/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementChartTreeTableModel.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementchart/FinancialStatementChartTreeTableModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementchart;

import static org.nuiton.i18n.I18n._;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialStatementServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

/**
 * Tree table model for account edition.
 * 
 * @author ore
 * @author chatellier
 * @version $Revision: 3051 $
 * 
 * Last update : $Date: 2010-11-29 15:57:16 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class FinancialStatementChartTreeTableModel extends AbstractTreeTableModel {
    
    /** log. */
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    
    /** Services. */
    protected final FinancialStatementServiceMonitorable financialStatementService;

    /**
     * Model constructor. Init account service used here.
     */
    public FinancialStatementChartTreeTableModel() {
        //create root for the tree
        super(new FinancialStatementImpl());
        // Gets factory service 
        financialStatementService =
            LimaServiceFactory.getInstance().getService(
                    FinancialStatementServiceMonitorable.class);
        }


    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0:
                res = _("lima.table.label");
                break;
            case 1:
                res = _("lima.table.debitcredit");
                break;
            case 2:
                res = _("lima.table.debit");
                break;
            case 3:
                res = _("lima.table.credit");
                break;
            case 4:
                res = _("lima.table.provisiondeprecationamount");
                break;
        }
        return res;
    }

    @Override
    public int getChildCount(Object node) {
        int result = 0;
        if (node == getRoot()) {
            try {
                result = financialStatementService.
                    getChildrenFinancialStatement(null).size();
            } catch (LimaException eee) {
                log.debug("Can't count child", eee);
            }
        }
        else {
                FinancialStatement parentFinancialStatementHeader =
                    (FinancialStatement) node;
                try {
                    result = financialStatementService.getChildrenFinancialStatement(
                            parentFinancialStatementHeader).size();
                } catch (LimaException eee) {
                    log.debug("Can't count child", eee);
                }    
            }
        return result;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == getRoot()) {
            try {
                List<FinancialStatement> financialStatements =
                    financialStatementService.getChildrenFinancialStatement(null);
                result = financialStatements.get(index);
            } catch (LimaException eee) {
                log.debug("Can't get child", eee);
            }
        }
        else {
            FinancialStatement parentFinancialStatement =
                (FinancialStatement) parent;
            try {
                List<FinancialStatement> financialStatements = financialStatementService.
                getChildrenFinancialStatement(parentFinancialStatement);
                result = financialStatements.get(index);
            } catch (LimaException eee) {
                log.debug("Can't get child", eee);
            }
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = 0;
        
        if (parent == getRoot()) {
            try {
                List<FinancialStatement> financialStatements =
                    financialStatementService.getChildrenFinancialStatement(null);
                result = financialStatements.indexOf(child);
            } catch (LimaException eee) {
                log.debug("Can't get index child", eee);
            }
        }
        else {
            FinancialStatement parentFinancialStatement =
                (FinancialStatement) parent;
            try {
                List<FinancialStatement> financialStatements = financialStatementService.
                    getChildrenFinancialStatement(parentFinancialStatement);
                result = financialStatements.indexOf(child);
            } catch (LimaException eee) {
                log.debug("Can't get index child", eee);
            }
        }
        return result;
    }
    
    @Override
    public Object getValueAt(Object node, int column) {
        Object result = "n/a";
            FinancialStatement financialStatement = (FinancialStatement) node;
            switch (column) {
                case 0:
                    result = financialStatement.getLabel();
                    break;
                case 1:
                    result = financialStatement.getAccounts();
                    break;
                case 2:
                    result = financialStatement.getDebitAccounts();
                    break;
                case 3:
                    result = financialStatement.getCreditAccounts();
                    break;
                case 4:
                    result = financialStatement.getProvisionDeprecationAccounts();
                    break;
            }
        return result;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    @Override
    public boolean isLeaf(Object node) {
        return getChildCount(node) == 0;
    }

    
    /**
     * Refresh FinancialStatementChart.
     *
     */
    public void refreshTree() throws LimaException {

        modelSupport.fireNewRoot();
    }
    
    
    /**
     * Add FinancialStatement(path can be null).
     * 
     * @param path
     * @param account
     * @throws LimaException
     */
    public void addFinancialStatement(TreePath path, FinancialStatement financialStatement) throws LimaException {
        // Calling account service
        FinancialStatement parentFinancialStatementHeader =
            (FinancialStatement) path.getLastPathComponent();
        if (parentFinancialStatementHeader == getRoot()) {
            parentFinancialStatementHeader = null;
        }
        financialStatementService.createFinancialStatement(
                parentFinancialStatementHeader, financialStatement);
        modelSupport.fireTreeStructureChanged(path);
    }

    
    /**
     * Update financialStatement
     * 
     * @param path
     * @param account
     * @throws LimaException
     */
    public void updateFinancialStatement(TreePath path, FinancialStatement financialStatement) throws LimaException {

        financialStatementService.updateFinancialStatement(financialStatement);
        modelSupport.fireTreeStructureChanged(path);
    }
    
    
    /**
     * Remove financialStatement
     * 
     * @param path
     * @param object
     * @throws LimaException
     */
    public void removeFinancialStatementObject(TreePath path, FinancialStatement financialStatement) throws LimaException {
        // Calling account service
        int index = getIndexOfChild(
                path.getParentPath().getLastPathComponent(), financialStatement);
        financialStatementService.removeFinancialStatement(financialStatement);    
        modelSupport.fireChildRemoved(path.getParentPath(), index, financialStatement);
    }
}
