/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodComboBoxRenderer.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/combobox/FinancialPeriodComboBoxRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.combobox;

import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.chorem.lima.entity.FinancialPeriod;


public class FinancialPeriodComboBoxRenderer extends DefaultListCellRenderer {

    private static final long serialVersionUID = 1L;

    @Override
    public Component getListCellRendererComponent(JList list,
            Object value,
            int index,
            boolean isSelected,
            boolean cellHasFocus) {
        // TODO Auto-generated method stub
        
        JLabel label = new JLabel();
        FinancialPeriod financialPeriod = (FinancialPeriod) value;
        if (financialPeriod != null){
            SimpleDateFormat simpleDateFormat
                = new SimpleDateFormat("dd MMM yy"); 
            label.setText(simpleDateFormat.format(financialPeriod.getBeginDate())+" - "+simpleDateFormat.format(financialPeriod.getEndDate()));
        }
         return label;
    }

    
}