/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountsReportsViewHandler.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/accountsreports/AccountsReportsViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.accountsreports;

import static org.nuiton.i18n.I18n._;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.combobox.AccountComboBoxModel;
import org.chorem.lima.util.ErrorHelper;


/**
 * Handler associated with accounts reports view.
 * By : $Author: echatellier $
 */
public class AccountsReportsViewHandler implements ServiceListener {

    protected AccountsReportsView view;
    
    protected AccountsReportsTableModel tableModel;
    
    protected AccountComboBoxModel comboBoxModel;
    
    /** log. */
    private static final Log log = LogFactory.getLog(AccountsReportsViewHandler.class);
    
    /** Account. */
    protected Account selectedAccount;
    
    /** Begin Date. */
    protected Date selectedBeginDate;
    
    /** EndDate. */
    protected Date selectedEndDate;
    
    /** Services. */
    protected ReportServiceMonitorable reportService;
        
    protected AccountsReportsViewHandler(AccountsReportsView view) {
        this.view = view;
        
        reportService =
            LimaServiceFactory.getInstance().getService(
                    ReportServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
        LimaServiceFactory.getInstance().getService(
                FinancialTransactionServiceMonitorable.class).addListener(this);
    }
    
    public void setBeginDate(Date date){
        selectedBeginDate = date;
        refresh();
    }
    
    public void setEndDate(Date date){
        selectedEndDate = date;
        refresh();
    }
    

    public void setAccount(Account account) {
        selectedAccount = account;
        refresh();
    }
    
    public ReportsDatas getDataList(){
        ReportsDatas results = null;
        //avoid unnecessary call to service
        if (selectedAccount != null){
            try {
                results = reportService.generateAccountsReports(selectedAccount, true,
                        selectedBeginDate, selectedEndDate);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug("Can't update model", eee);
                }
                ErrorHelper.showErrorDialog("Can't get entries list", eee);
            }
        }
        return results;
    }
    
    public void refresh(){
        
        if (selectedBeginDate != null && selectedEndDate != null && selectedAccount != null){
            ReportsDatas datasList = getDataList();
    
            tableModel = view.getModelAccountsReportsTable();
            tableModel.refresh(datasList);
        
        /**
         * set text and amounts of labels credit, debit, solde
         */
            
            if (datasList != null){
                // set amounts credit and debit and solde
                view.amountCreditLabel.setText(
                        datasList.getAmountCredit().toString());
                view.amountDebitLabel.setText(
                        datasList.getAmountDebit().toString());
                BigDecimal amountSolde = datasList.getAmountSolde();
                view.amountSoldeLabel.setText(amountSolde.toString());
                
                
                if (amountSolde.doubleValue() == 0){
                    view.soldeLabel.setText(_("lima.common.solde"));
                }
                else {
                    // set label solde: credit or debit
                    if (datasList.getSoldeDebit()) {
                        view.soldeLabel.setText(_("lima.common.soldedebit"));
                    }
                    else {
                        view.soldeLabel.setText(_("lima.common.soldecredit"));
                    }
                }
            }
        }
    }
    
    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importAccount") || methodeName.contains("importAll")){
            refresh();
        }
    }
    
}
