/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialperiod;

import static org.nuiton.i18n.I18n._;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialPeriodServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.service.LimaServiceFactory;

/**
 * TODO add comment here.
 * 
 * @author chatellier
 * @version $Revision: 2884 $
 * 
 * Last update : $Date: 2010-05-06 11:57:19 +0200 (jeu. 06 mai 2010) $
 * By : $Author: jpepin $
 */
public class FinancialPeriodTableModel extends AbstractTableModel implements ServiceListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = 77027335135838258L;

    private static final Log log =
        LogFactory.getLog(FinancialPeriodTableModel.class);

    /** service */
    protected FinancialPeriodServiceMonitorable financialPeriodService;
    
    /** Datas cache */
    protected List<ClosedPeriodicEntryBook> cacheDataList;
    
    public FinancialPeriodTableModel() {
        financialPeriodService =
            LimaServiceFactory.getInstance().getService(
            		FinancialPeriodServiceMonitorable.class);
    	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
    	LimaServiceFactory.getInstance().getService(
    			FiscalPeriodServiceMonitorable.class).addListener(this);
    }
    
    
    @Override
    public int getRowCount() {
        return cacheDataList.size();
    }


    @Override
    public int getColumnCount() {
        return 3;
    }


    @Override
    public String getColumnName(int columnIndex) {
        
        String result = "n/a";
        
        switch(columnIndex) {
        case 0 :
            result = _("lima.table.period");
            break;
        case 1:
            result = _("lima.table.entrybook");
            break;
        case 2:
            result = _("lima.table.closure");
            break;
        }

        return result;
    }

   
    @Override
    public Class<?> getColumnClass(int columnIndex) {
        // both String
        return String.class;
    }

    
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ClosedPeriodicEntryBook getFinancialPeriodAtRow(int row) throws LimaException {
        return cacheDataList.get(row);
    }
    
    
    public Object getElementAt(int row){
        
        Object currentRow = cacheDataList.get(row);
        return currentRow;
    }
    
    
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;

        ClosedPeriodicEntryBook closedPeriodicEntryBook
                = cacheDataList.get(rowIndex);
            
            if (closedPeriodicEntryBook != null){
                EntryBook entryBook = closedPeriodicEntryBook.getEntryBook();
                FinancialPeriod financialPeriod =
                    closedPeriodicEntryBook.getFinancialPeriod();
                
                SimpleDateFormat simpleDateFormat
                    = new SimpleDateFormat("dd MMM yyyy");                
                
                switch (columnIndex) {
                case 0:
                    result = simpleDateFormat.format(financialPeriod.getBeginDate())
                        +" - "+simpleDateFormat.format(financialPeriod.getEndDate());
                    break;
                case 1:
                    result = entryBook.getCode()+" - "+entryBook.getLabel();
                    break;
                case 2:
                    if(closedPeriodicEntryBook.getLocked()){
                        result = _("lima.common.closed");
                    }
                    else{
                        result = _("lima.common.open");
                    }
                    break;
                }
            }
        return result;
    }
    
    public void getDataList(){
        List<ClosedPeriodicEntryBook> results =
            new ArrayList<ClosedPeriodicEntryBook>();
        try {
            results = financialPeriodService.//getAllClosedPeriodicEntryBooks();
               getAllClosedPeriodicEntryBooksFromUnblockedFiscalPeriod();
        } catch (LimaException eee){
            if (log.isDebugEnabled()){
                log.debug("Can't get closedperiodicentrybook list", eee );
            }
        }
        cacheDataList=results;
    }
    
    public void blockFinancialPeriod(ClosedPeriodicEntryBook closedPeriodicEntryBook) throws LimaException {
        financialPeriodService.
            blockClosedPeriodicEntryBook(closedPeriodicEntryBook);
        fireTableDataChanged();
    }


	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		if (methodeName.contains("FiscalPeriod") || methodeName.contains("importAll")){
			getDataList();
	        fireTableDataChanged();
		}
	}
}
