/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

/**
 * Account combo box model.
 */

public class LetterComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener {
    
	private static final long serialVersionUID = 1L;

	private static final Log log =
		LogFactory.getLog(FinancialPeriodTableModel.class);
    
    protected Object selectedAccount;
    
    protected List<Letter> datasCache;
    
    protected FinancialTransactionServiceMonitorable service;
        
    public LetterComboBoxModel () {
    	service =
        	LimaServiceFactory.getInstance().getService(
        			FinancialTransactionServiceMonitorable.class);
    	service.addListener(this);
    	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
        datasCache = getDataList();
    }
    
    @Override
    public Object getSelectedItem() {
       return selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selectedAccount = anItem;
    	fireContentsChanged(this, -1, -1); 
    }


    @Override
    public Object getElementAt(int index) {
    	return datasCache.get(index);
    }

    @Override
    public int getSize() {
         return datasCache.size();
    }

    public List<Letter> getDataList(){
        List<Letter> result = null;
        try {
            result = service.getAllLetters();
        }
        catch (LimaException eee) {
            if (log.isDebugEnabled()){
                log.debug("Can't get list letters", eee);
            }
        }
        return result;
        
    }
    
    public void refresh(){
    	datasCache = getDataList();
    	fireContentsChanged(this, 0, datasCache.size());
    }

	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		if (methodeName.contains("Letter") || methodeName.contains("importAll")){
			refresh();
		}		
	}

    
}
