/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima;

import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.MainViewHandler;
import org.nuiton.i18n.I18n;

import java.util.Locale;

/**
 * @author chemit
 */
public class LimaContext extends jaxx.runtime.context.DefaultApplicationContext {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(LimaContext.class);

    /**
     * l'intance partagée accessible après un appel à la méthode
     * {@link #init()}
     */
    protected static LimaContext instance;

    public static JAXXContextEntryDef<MainView> MAIN_UI_ENTRY_DEF = JAXXUtil.newContextEntryDef("mainUI", MainView.class);

    /**
     * @return <code>true</code> si le context a été initialisé via la méthode
     *         {@link #init()}, <ocde>false</code> autrement.
     */
    public static boolean isInit() {
        return instance != null;
    }

    /**
     * Permet l'initialisation du contexte applicatif et positionne
     * l'instance partagée.
     * <p/>
     * Note : Cette méthode ne peut être appelée qu'une seule fois.
     *
     * @return l'instance partagée
     * @throws IllegalStateException si un contexte applicatif a déja été positionné.
     */
    public static synchronized LimaContext init() throws IllegalStateException {
        if (isInit()) {
            throw new IllegalStateException("there is already a application context registred.");
        }
        instance = new LimaContext();
        instance.setContextValue(new LimaConfig());
        instance.setContextValue(new MainViewHandler());

        return instance;
    }

    /**
     * Récupération du contexte applicatif.
     *
     * @return l'instance partagé du contexte.
     * @throws IllegalStateException si le contexte n'a pas été initialisé via
     *                               la méthode {@link #init()}
     */
    public static LimaContext get() throws IllegalStateException {
        if (!isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    public LimaConfig getConfig() {
        return getContextValue(LimaConfig.class);
    }

    public void initI18n() {

        Locale locale = getConfig().getLocale();
        I18n.init(locale);
        // Default Locale for DatePicker
        Locale.setDefault(locale);
    }

    public MainView getMainUI() {
        return (MainView) MAIN_UI_ENTRY_DEF.getContextValue(this);
    }

    /**
     * close the application's context.
     *
     * @throws java.lang.Exception if any pb while closing
     */
    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("closing context " + this);
        }

        // fermeture du context principal
        MainView mainUI = getMainUI();
        if (mainUI != null && mainUI.isVisible()) {
            mainUI.setVisible(false);
            mainUI.dispose();
        }

        if (log.isDebugEnabled()) {
            log.debug("context closed " + this);
        }
        //System.exit(0);
    }

    public static LimaContext getContext() {
        return get();
    }
}
