/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
/**
 * # #% Copyright (C) 2008 Code Lutin, Tony Chemit 
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * # #%
 */
package org.chorem.lima.service.neogia;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.*;
import org.chorem.lima.service.EntryService;
import org.chorem.lima.service.ServiceFactory;
import org.chorem.lima.service.TransactionService;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.proxies.*;
import org.ofbiz.webservice.proxies.AddTransactionDocument.AddTransaction;
import org.ofbiz.webservice.proxies.RemoveTransactionDocument.RemoveTransaction;
import org.ofbiz.webservice.proxies.UpdateTransactionDocument.UpdateTransaction;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionItem;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionItemAndGlPeriod;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JProgressBar;

/**
 * @author chemit
 */
public class NeogiaTransactionService implements TransactionService {

    /**
     * log
     */
    protected static final Log log = LogFactory.getLog(NeogiaPeriodService.class);

    @Override
    public List<TransactionDTO> getAllTransaction(List<PeriodDTO> periods, List<JournalDTO> journals, List<AccountDTO> accounts, List<StatusDTO> status) {
        if (log.isDebugEnabled()) {
            log.debug("getAllTransaction : ");
        }
        try {
            List<TransactionDTO> list = new LinkedList<TransactionDTO>();

            ServiceFactory neogiaFactory = ServiceFactory.getServiceFactory();
            EntryService entryServ = neogiaFactory.getEntryService();

            GetAllTransactionStub stub = new GetAllTransactionStub();
            GetAllTransactionResponseDocument response = stub.getAllTransaction();
            GenericValueAcctgTransactionItemAndGlPeriod[] array = response.getGetAllTransactionResponse().getReturnArray();

            for (GenericValueAcctgTransactionItemAndGlPeriod value : array) {
                TransactionDTO trans = NeogiaUtil.mapToTransactionDTO(value, periods, journals, status);
                List<EntryDTO> entries = entryServ.getEntryByTransaction(trans, accounts);
                for (EntryDTO entry : entries) {
                    trans.addChild(entry);
                }
                list.add(trans);
            }
            return list;
        } catch (RemoteException ex) {
            log.error(ex);
        }
        return null;
    }

    @Override
    public List<TransactionDTO> getAllTransaction(List<PeriodDTO> periods,
            List<JournalDTO> journals, List<AccountDTO> accounts,
            List<StatusDTO> status,JProgressBar barre) {
        return getAllTransaction(periods,journals,accounts,status);
    }


    @Override
    public String removeTransaction(TransactionDTO trans,List<StatusDTO> status) {
        if (log.isDebugEnabled()) {
            log.debug("removeTransaction : ");
        }
        // Remove entries
        for (EntryDTO entry : trans.getEntries()) {
            String response = ServiceFactory.getServiceFactory().getEntryService().removeEntry(null, entry);
            if (ServiceHelper.RESPOND_SUCCESS.equals(response)) {
                if (log.isDebugEnabled()) {
                    log.debug("Entry removed : " + entry.getIdSeq());
                }
            } else {
                if (log.isErrorEnabled()) {
                    log.error("Entry can't be removed : " + entry.getIdSeq());
                }
                return ServiceHelper.RESPOND_ERROR;
            }
        }

        try {
            RemoveTransactionStub stub = new RemoveTransactionStub();
            RemoveTransactionDocument document = RemoveTransactionDocument.Factory.newInstance();
            RemoveTransaction element = RemoveTransaction.Factory.newInstance();
            element.setAtranIdName(trans.getIdName());
            element.setSequenceId(trans.getIdSeq());
            element.setIdNumPeriod(trans.getPeriod().getIdSeq());
            document.setRemoveTransaction(element);

            stub.removeTransaction(document);

            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.error(ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String updateTransaction(List<StatusDTO> list, TransactionDTO oldTrans, TransactionDTO newTrans) {
        if (log.isDebugEnabled()) {
            log.debug("updateTransaction : ");
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(newTrans.getEntryDate());

            UpdateTransactionStub stub = new UpdateTransactionStub();
            UpdateTransactionDocument document = UpdateTransactionDocument.Factory.newInstance();
            UpdateTransaction element = UpdateTransaction.Factory.newInstance();
            element.setAtranIdName(newTrans.getIdName());
            element.setSequenceId(newTrans.getIdSeq());
            element.setDescription(newTrans.getDescription());
            element.setEntryDate(cal);
            element.setAtrnstypIdName(newTrans.getJournal().getIdName());
            element.setVoucherRef(newTrans.getVoucherRef());
            if (newTrans.getPeriod() != oldTrans.getPeriod()) {
                element.setIdNumPeriod(oldTrans.getPeriod().getIdSeq());
                element.setNewIdNumPeriod(newTrans.getPeriod().getIdSeq());
            }
            document.setUpdateTransaction(element);

            UpdateTransactionResponseDocument response = stub.updateTransaction(document);
            String status = response.getUpdateTransactionResponse().getReturn();
            newTrans.setStatus(ServiceHelper.findStatusById(list, status));
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.error(ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String addTransaction(TransactionDTO trans,List<StatusDTO> status) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("addTransaction : ");
            }
            AddTransactionStub stub = new AddTransactionStub();
            AddTransactionDocument document = AddTransactionDocument.Factory.newInstance();
            AddTransaction element = AddTransaction.Factory.newInstance();
            element.setIdNumPeriod(trans.getPeriod().getIdSeq());
            Calendar cal = Calendar.getInstance();
            cal.setTime(trans.getEntryDate());
            element.setEntryDate(cal);
            element.setAtrnstypIdName(trans.getJournal().getIdName());
            document.setAddTransaction(element);
            AddTransactionResponseDocument response = stub.addTransaction(document);
            GenericValueAcctgTransactionItem value = response.getAddTransactionResponse().getReturn();
            trans.setIdName(value.getAtranIdName());
            trans.setIdSeq(value.getSequenceId());
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.error(ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }
}
