/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *
 * Copyright (C) 2010 Code Lutin, Eric Chatellier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/

package org.chorem.jtimer.ui.system.macos;

import com.sun.jna.Library;
import com.sun.jna.Native;

/**
 * Quartz 2D API.
 * 
 * @author chatellier
 * @version $Revision: 2717 $
 * @since 1.3.2
 * 
 * Last update : $Date: 2010-01-04 10:02:46 +0100 (lun., 04 janv. 2010) $
 * By : $Author: chatellier $
 */
public interface ApplicationServices extends Library {

    ApplicationServices INSTANCE = (ApplicationServices) Native.loadLibrary(
            "ApplicationServices", ApplicationServices.class);

    /** Constants that specify an input event. */
    int kCGAnyInputEventType = -1;
    /** Specifies that an event source should use a private event state table. */
    int kCGEventSourceStatePrivate = -1;
    /** Specifies that an event source should use the event state table that reflects the combined state of all event sources posting to the current user login session. */
    int kCGEventSourceStateCombinedSessionState = 0;
    /** Specifies that an event source should use the event state table that reflects the combined state of all hardware event sources posting from the HID system. */
    int kCGEventSourceStateHIDSystemState = 1;

    /**
     * Returns the elapsed time since the last event for a Quartz event source.
     *
     * @param sourceStateId The source state to access
     * @param eventType The event type to access
     * @return the time in seconds since the previous input event of the specified type
     * 
     * @see <a href="http://developer.apple.com/mac/library/documentation/Carbon/Reference/QuartzEventServicesRef/Reference/reference.html#//apple_ref/c/func/CGEventSourceSecondsSinceLastEventType">Quartz API</a>
     */
    public double CGEventSourceSecondsSinceLastEventType(int sourceStateId,
            int eventType);
}