/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.entities;

import java.io.Serializable;

/**
 * Alert.
 * 
 * @author chatellier
 * @version $Revision: 2677 $
 * 
 * Last update : $Date: 2009-10-15 11:29:00 +0200 (jeu., 15 oct. 2009) $
 * By : $Author: echatellier $
 */
public class TimerAlert implements Serializable, Cloneable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 584921087501157113L;

    /**
     * Alert type.
     */
    public static enum Type {
        REACH_DAILY_TIME,
        REACH_TOTAL_TIME
    }

    /** Alert type. */
    protected Type type;

    /** Alert duration. (in seconds) */
    protected long duration;

    /**
     * Constructor.
     */
    public TimerAlert() {

    }

    /**
     * Constructor.
     * 
     * @param type type
     * @param duration duration
     */
    public TimerAlert(Type type, long duration) {
        this();
        this.type = type;
        this.duration = duration;
    }

    /**
     * Get alert type.
     * 
     * @return the type
     */
    public Type getType() {
        return type;
    }

    /**
     * Set alert type.
     * 
     * @param type the type to set
     */
    public void setType(Type type) {
        this.type = type;
    }

    /**
     * Get duration.
     * 
     * @return the duration in seconds
     */
    public long getDuration() {
        return duration;
    }

    /**
     * Set duration.
     * 
     * @param duration the duration to set (in seconds)
     */
    public void setDuration(long duration) {
        this.duration = duration;
    }

    /*
     * @see java.lang.Object#clone()
     */
    @Override
    public TimerAlert clone() {
        TimerAlert clone = null;
        try {
            clone = (TimerAlert)super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException("Can't clone", e);
        }
        return clone;
    }

    /*
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (int) (duration ^ (duration >>> 32));
        result = 31 * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    /*
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        boolean result = false;

        if (obj instanceof TimerAlert) {
            TimerAlert other = (TimerAlert) obj;
            
            result = duration == other.duration;
            if (type != null) {
                result &= type.equals(other.type);
            }
            else {
                result &= other.type == null;
            }
        }
        return result;
    }
}
