<#--
 #%L
 jTimer
 
 $Id$
 $HeadURL$
 %%
 Copyright (C) 2007 - 2012 CodeLutin
 %%
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as
 published by the Free Software Foundation, either version 3 of the 
 License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public 
 License along with this program.  If not, see
 <http://www.gnu.org/licenses/gpl-3.0.html>.
 #L%
-->
Report by year
==============

<#macro displaySubtaskReport task periodTime identation=0>
  <#local ident=identation + 1/>
  <#list task.subTasks as subtask>
    <#local taskTotalTime=utils.getYearlyTotalTaskTime(subtask, periodTime?date, begin?date, end?date)/>
    <#if taskTotalTime &gt; 0>
    	<#local taskTime=utils.getYearlyTaskTime(subtask, periodTime?date, begin?date, end?date)/>
<#list 1..ident as i>  </#list>- ${subtask.name}<#if taskTime &gt; 0> : ${utils.formatDuration(taskTime)}</#if>
    	<#if annotations>
	    	<#local taskAnnotations=utils.getYearlyTaskAnnotation(subtask, periodTime?date, begin?date, end?date)/>
	    	<#list taskAnnotations as taskAnnotation>
<#list 1..ident as i>  </#list>  * ${taskAnnotation}
      		</#list>
      	</#if>
  	  <@displaySubtaskReport task=subtask periodTime=periodTime identation=ident/>
  	</#if>
  </#list>
</#macro>

<#assign periods=utils.getYearlyDates(begin?date,end?date)/>
<#list periods as period>
<#assign periodTotalTime=0/>
<#list projects as project>
  <#assign projectPeriodTotalTime=utils.getYearlyTotalTaskTime(project, period?date, begin?date, end?date)/>
  <#assign periodTotalTime=periodTotalTime+projectPeriodTotalTime/>
</#list>
<#if periodTotalTime &gt; 0>

<#assign title="Year ${period?date?string('yyyy')}"/>
${title}
${""?left_pad(title?length,"-")}

<#list projects as project>
<#assign periodProjectTotalTime=utils.getYearlyTotalTaskTime(project, period?date, begin?date, end?date)/>
<#if periodProjectTotalTime &gt; 0>
- ${project.name}
<@displaySubtaskReport task=project periodTime=period/>
</#if>
</#list>

Total : ${utils.formatDuration(periodTotalTime)}
</#if>
</#list>
