/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ws;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.data.VetoableDataEventListener;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ws.exception.WebServiceException;

/**
 * ProjectManagement.
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven., 22 mai 2009) $
 * By : $Author: chatellier $
 */
public interface ProjectManagement extends DataEventListener, VetoableDataEventListener {

    /**
     * Set service endpoint.
     * 
     * @param endpoint service endpoint
     */
    public void setEndpoint(String endpoint);

    /**
     * Set service endpoint.
     * 
     * @return service endpoint
     */
    public String getEndpoint();

    /**
     * Set service resource name.
     * 
     * @param name service resource name
     */
    public void setResourceName(String name);

    /**
     * Get service resource name.
     * 
     * @return service resource name
     */
    public String getResourceName();

    /**
     * Set data manager.
     * 
     * @param dataManager data manager
     */
    public void setDataManager(TimerDataManager dataManager);
    
    /**
     * Set connection handler.
     * 
     * @param connectionDataHandler connection handler
     */
    public void setConnectionDataHandler(ConnectionDataHandler connectionDataHandler);
    
    /**
     * Get id/login map available on remote services.
     * 
     * @throws WebServiceException when call fail
     * @return all id/login couple
     */
    public Map<String, String> getIdAndLoginsMap() throws WebServiceException;

    /**
     * Do login operation
     * 
     * @param user username
     * @param password password
     * @throws WebServiceException when call fail
     * @return user id
     */
    public String login(String user, String password)
            throws WebServiceException;

    /**
     * Get project list
     * 
     * @param userId user id
     * 
     * @throws WebServiceException when call fail
     * @return list of project
     * @see org.chorem.jtimer.entities.TimerProject
     */
    public List<TimerProject> getUserProjects(String userId)
            throws WebServiceException;

    /**
     * Synchronize a single project.
     * 
     * @param userId user id
     * @param projects project list to synchronize
     * @throws WebServiceException when call fail
     */
    public void synchronize(String userId, List<TimerProject> projects)
            throws WebServiceException;

    /**
     * Sync a task.
     * 
     * @param userId user id
     * @param task task to sync 
     * @param dateOfDay date
     * @param timeOfDay time in seconds
     * @throws WebServiceException when call fail
     */
    public void syncTask(String userId, TimerTask task, Date dateOfDay,
            long timeOfDay) throws WebServiceException;
}
