/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.alert;

import java.awt.Component;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.chorem.jtimer.entities.TimerAlert.Type;
import org.chorem.jtimer.ui.widget.DurationEditor;

/**
 * Tree cell editor for alerts table.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 6 juil. 2009 $
 * By : $Author: chatellier $
 */
public class AlertCellRenderer extends DefaultTableCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -363052829182024180L;

    /*
     * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        Component superComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Component c = null;
        switch (column) {
        case 0:
            JComboBox combo = new JComboBox();
            combo.addItem(Type.REACH_DAILY_TIME);
            combo.addItem(Type.REACH_TOTAL_TIME);
            combo.setSelectedItem(value);
            c = combo;
            break;

        case 1:
            DurationEditor durationEditor = new DurationEditor(9999);
            long duration = ((Long)value).longValue();
            durationEditor.setDuration(duration);
            c = durationEditor;
            break;
            
        default:
            break;
        }
        
        // restore super properties
        c.setBackground(superComponent.getBackground());

        return c;
    }
}
