/* *##%
 * Copyright (C) 2008, 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.io;

/**
 * Exception thrown when saver directory has already been locked.
 *
 * @author chatellier
 * @version $Revision: 2607 $
 * 
 * Last update : $Date: 2009-06-18 17:19:19 +0200 (jeu., 18 juin 2009) $
 * By : $Author: echatellier $
 */
public class DataLockingException extends Exception {

    /** serialVersionUID */
    private static final long serialVersionUID = 3535577909976711886L;

    /**
     * Constructor with text message.
     * 
     * @param message text message
     */
    public DataLockingException(String message) {
        super(message);
    }

    /**
     * Constructor with text message and cause.
     * 
     * @param message text message
     * @param cause parent cause
     */
    public DataLockingException(String message, Throwable cause) {
        super(message, cause);
    }

}
