Report by week
==============

<#macro displaySubtaskReport task periodTime identation=0>
  <#local ident=identation + 1/>
  <#list task.subTasks as subtask>
    <#local taskTotalTime=utils.getWeeklyTotalTaskTime(subtask, periodTime?date, begin?date, end?date)/>
    <#if taskTotalTime &gt; 0>
    	<#local taskTime=utils.getWeeklyTaskTime(subtask, periodTime?date, begin?date, end?date)/>
<#list 1..ident as i>  </#list>- ${subtask.name}<#if taskTime &gt; 0> : ${utils.formatDuration(taskTime)}</#if>
    	<#if annotations>
	    	<#local taskAnnotations=utils.getWeeklyTaskAnnotation(subtask, periodTime?date, begin?date, end?date)/>
	    	<#list taskAnnotations as taskAnnotation>
<#list 1..ident as i>  </#list>  * ${taskAnnotation}
      		</#list>
      	</#if>
  	  <@displaySubtaskReport task=subtask periodTime=periodTime identation=ident/>
  	</#if>
  </#list>
</#macro>

<#assign periods=utils.getWeeklyDates(begin?date,end?date)/>
<#list periods as period>
<#assign periodTotalTime=0/>
<#list projects as project>
  <#assign projectPeriodTotalTime=utils.getWeeklyTotalTaskTime(project, period?date, begin?date, end?date)/>
  <#assign periodTotalTime=periodTotalTime+projectPeriodTotalTime/>
</#list>
<#if periodTotalTime &gt; 0>

<#assign title="Week ${period?date?string('ww yyyy')}"/>
${title}
${""?left_pad(title?length,"-")}

<#list projects as project>
<#assign periodProjectTotalTime=utils.getWeeklyTotalTaskTime(project, period?date, begin?date, end?date)/>
<#if periodProjectTotalTime &gt; 0>
- ${project.name}
<@displaySubtaskReport task=project periodTime=period/>
</#if>
</#list>

Total : ${utils.formatDuration(periodTotalTime)}
</#if>
</#list>
