Report by project
=================

<#assign periods=utils.getDailyDates(begin?date,end?date)/>
<#macro displaySubtaskReport task identation=0>
  <#local ident=identation + 1/>
  <#list task.subTasks as subtask>
    <#local taskTotalTime=0/>
    <#list periods as period>
      <#local subtaskPeriodTotalTime=utils.getDailyTotalTaskTime(subtask, period?date)/>
      <#local taskTotalTime=taskTotalTime+subtaskPeriodTotalTime/>
    </#list>
    <#if taskTotalTime &gt; 0>
        <#local taskTime=0/>
        <#list periods as period>
          <#local subtaskPeriodTime=utils.getDailyTaskTime(subtask, period?date)/>
          <#local taskTime=taskTime+subtaskPeriodTime/>
        </#list>
<#list 1..ident as i>  </#list>- ${subtask.name}<#if taskTime &gt; 0> : ${utils.formatDuration(taskTime)}</#if>
    	<#if annotations>
        	<#list periods as period>
	    		<#local taskAnnotations=utils.getDailyTaskAnnotation(subtask, period?date)/>
	    		<#list taskAnnotations as taskAnnotation>
<#list 1..ident as i>  </#list>  * ${taskAnnotation}
      			</#list>
	        </#list>
      	</#if>
  	  <@displaySubtaskReport task=subtask identation=ident/>
  	</#if>
  </#list>
</#macro>

<#list projects as project>
  <#assign periodTotalTime=0/>
  <#list periods as period>
    <#assign projectPeriodTotalTime=utils.getDailyTotalTaskTime(project, period?date)/>
    <#assign periodTotalTime=periodTotalTime+projectPeriodTotalTime/>
  </#list>
<#if periodTotalTime &gt; 0>

<#assign title="${project.name}"/>
${title}
${""?left_pad(title?length,"-")}

<@displaySubtaskReport task=project/>

Total : ${utils.formatDuration(periodTotalTime)}
</#if>
</#list>
