/* *##%
 * Copyright (C) 2008, 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.data;

import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.List;

import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

/**
 * Data event listener.
 * 
 * @author chatellier
 * @version $Revision: 2630 $
 * 
 * Last update : $Date: 2009-07-21 19:06:31 +0200 (mar. 21 juil. 2009) $ By : $Author: echatellier $
 */
public interface DataEventListener extends EventListener {

    /**
     * Add project event.
     * 
     * @param project project to add
     */
    public void addProject(TimerProject project);

    /**
     * Add task event.
     * 
     * @param task task to add
     */
    public void addTask(TimerTask task);

    /**
     * Modify project.
     * 
     * @param project modified project
     */
    public void modifyProject(TimerProject project);

    /**
     * Modify task.
     * 
     * @param task modified task
     */
    public void modifyTask(TimerTask task);

    /**
     * Before delete project.
     * 
     * TODO only usefull for UI (can't known on to delete if already deleted)
     * 
     * @param project deleted project
     */
    public void preDeleteProject(TimerProject project);
    
    /**
     * Before delete task.
     * 
     * TODO only usefull for UI (can't known on to delete if already deleted)
     * 
     * @param task deleted task
     */
    public void preDeleteTask(TimerTask task);
    
    /**
     * Delete project.
     * 
     * @param project deleted project
     */
    public void deleteProject(TimerProject project);

    /**
     * Delete task.
     * 
     * @param task deleted task
     */
    public void deleteTask(TimerTask task);

    /**
     * Add annotation.
     * 
     * @param task task where annotation is changed
     * @param date date
     * @param annotation new annotation value
     */
    public void setAnnotation(TimerTask task, Date date, String annotation);

    /**
     * Set task time.
     * 
     * @param task task where time is changed
     * @param date date
     * @param time task time
     */
    public void setTaskTime(TimerTask task, Date date, Long time);

    /**
     * Pre change task state.
     * 
     * @param task task
     */
    public void preChangeClosedState(TimerTask task);

    /**
     * Post change task state.
     * 
     * @param task task
     */
    public void postChangeClosedState(TimerTask task);

    /**
     * Pre move task.
     * 
     * @param task task
     */
    public void preMoveTask(TimerTask task);

    /**
     * Post move task.
     * 
     * @param task task
     */
    public void moveTask(TimerTask task);
    
    /**
     * Pre merge task.
     * 
     * @param destinationTask task where all other task will be merged
     * @param otherTasks other tasks to merge
     */
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks);

    /**
     * Post merge task.
     * 
     * @param destinationTask task where all other task will be merged
     * @param otherTasks other tasks to merge
     */
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks);

    /**
     * Start task.
     * 
     * @param task started task
     */
    public void startTask(TimerTask task);

    /**
     * Stop task.
     * 
     * @param task stoped task
     */
    public void stopTask(TimerTask task);

    /**
     * All data loaded.
     * 
     * @param projects projects collection
     */
    public void dataLoaded(Collection<TimerProject> projects);
}
