/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system;

/**
 * Exception thrown when system info is not available.
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven. 22 mai 2009) $
 * By : $Author: chatellier $
 */
public class UnsupportedSystemInfoException extends Exception {

    /** serialVersionUID. */
    private static final long serialVersionUID = 138458861335881500L;

    /**
     * Constructor.
     */
    public UnsupportedSystemInfoException() {
        super();
    }

    /**
     * Constructor.
     * 
     * @param message message
     * @param cause cause
     */
    public UnsupportedSystemInfoException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     * 
     * @param message message
     */
    public UnsupportedSystemInfoException(String message) {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param cause cause.
     */
    public UnsupportedSystemInfoException(Throwable cause) {
        super(cause);
    }
}
