/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.io;

import java.util.Collection;

import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.VetoableDataEventListener;
import org.chorem.jtimer.entities.TimerProject;

/**
 * Common interface for jtimer data savers.
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven. 22 mai 2009) $
 * By : $Author: chatellier $
 */
public interface Saver extends DataEventListener, VetoableDataEventListener {

    /**
     * Set file directory.
     * 
     * @param directory directory
     */
    public void setSaveDirectory(String directory);

    /**
     * Set auto save delay (in milliseconds).
     * 
     * @param autoSaveDelay delay in milliseconds
     */
    public void setAutoSaveDelay(long autoSaveDelay);

    /**
     * Try to lock current saver directory.
     * 
     * @throws DataLockingException if can't obtain lock
     */
    public void lock() throws DataLockingException;

    /**
     * Try to unlock current saver directory.
     * 
     * @throws DataLockingException if there is no lock
     */
    public void unlock() throws DataLockingException;

    /**
     * Load a project list.
     * 
     * @return a collection of projects
     */
    public Collection<TimerProject> load();

}
