/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.provider.ContactsContract;
import android.telephony.SmsMessage;
import android.util.Log;
import java.io.Serializable;
import org.chorem.android.saymytexts.SMS;
import org.chorem.android.saymytexts.SayMyTextService;

public class NewTextBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "NewTextBroadcastReceiver";

    public void onReceive(Context context, Intent intent) {
        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        String action = intent.getAction();
        if ("android.provider.Telephony.SMS_RECEIVED".equals(action)) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                String key;
                SharedPreferences sharedPref;
                boolean blockEqualsSms;
                SmsMessage[] msgs = null;
                String messageReceived = "";
                Object[] pdus = (Object[])bundle.get("pdus");
                msgs = new SmsMessage[pdus.length];
                for (int i = 0; i < msgs.length; ++i) {
                    msgs[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
                    messageReceived = messageReceived + msgs[i].getDisplayMessageBody() + " ";
                }
                if ("=".equals(messageReceived.trim()) && (blockEqualsSms = (sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)context)).getBoolean(key = context.getString(2131034116), false))) {
                    this.abortBroadcast();
                    return;
                }
                String senderPhoneNumber = msgs[0].getDisplayOriginatingAddress();
                String senderName = this.getContactDisplayNameByNumber(context, senderPhoneNumber);
                SMS sms = new SMS(senderPhoneNumber, senderName, messageReceived);
                Log.d((String)TAG, (String)messageReceived);
                serviceIntent.putExtra("sms", (Serializable)sms);
                serviceIntent.setAction("org.chorem.android.saymytexts.READ_SMS");
                context.startService(serviceIntent);
            }
        } else {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            serviceIntent.setAction("org.chorem.android.saymytexts.ADD_BT_DEVICE");
            if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                int majorDeviceClass = device.getBluetoothClass().getMajorDeviceClass();
                if (majorDeviceClass == 1024) {
                    serviceIntent.putExtra("btDevice", (Parcelable)device);
                    serviceIntent.putExtra("addBtDevice", true);
                    context.startService(serviceIntent);
                }
            } else {
                serviceIntent.putExtra("btDevice", (Parcelable)device);
                serviceIntent.putExtra("addBtDevice", false);
                context.startService(serviceIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContactDisplayNameByNumber(Context context, String number) {
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)number));
        String name = number;
        ContentResolver contentResolver = context.getContentResolver();
        try (Cursor contactLookup = contentResolver.query(uri, new String[]{"_id", "display_name"}, null, null, null);){
            if (contactLookup != null && contactLookup.getCount() > 0) {
                contactLookup.moveToNext();
                name = contactLookup.getString(contactLookup.getColumnIndex("display_name"));
            }
        }
        return name;
    }
}

