/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.media.AudioTrack;
import java.util.ArrayList;
import java.util.List;

public class SayMyTextsUtils {
    public static final double QUAVER_DURATION = 0.25;
    public static final double BLACK_DURATION = 0.5;
    public static final double POINTED_BLACK_DURATION = 0.75;
    public static final int SAMPLE_RATE = 8000;
    public static final double G_FREQUENCY = 396.0;
    public static final double A_FREQUENCY = 440.0;
    public static final double B_FREQUENCY = 495.0;
    public static final double C_FREQUENCY = 528.0;
    public static final double D_FREQUENCY = 594.0;
    private static final List<Byte> FS_SONG_NOTES = new ArrayList<Byte>();

    public static boolean checkVoiceRecognition(Context context) {
        PackageManager pm = context.getPackageManager();
        List activities = pm.queryIntentActivities(new Intent("android.speech.action.RECOGNIZE_SPEECH"), 0);
        return activities.size() > 0;
    }

    public static void playFSSong() {
        if (FS_SONG_NOTES.isEmpty()) {
            SayMyTextsUtils.initFSSong();
        }
        SayMyTextsUtils.playSound();
    }

    private static void initFSSong() {
        ArrayList<Double> tones = new ArrayList<Double>();
        SayMyTextsUtils.genTone(tones, 594.0, 0.5);
        SayMyTextsUtils.genTone(tones, 528.0, 0.25);
        SayMyTextsUtils.genTone(tones, 495.0, 0.5);
        SayMyTextsUtils.genTone(tones, 440.0, 0.5);
        SayMyTextsUtils.genTone(tones, 495.0, 0.5);
        SayMyTextsUtils.genTone(tones, 528.0, 0.25);
        SayMyTextsUtils.genTone(tones, 495.0, 0.5);
        SayMyTextsUtils.genTone(tones, 440.0, 0.5);
        SayMyTextsUtils.genTone(tones, 396.0, 0.5);
        SayMyTextsUtils.genTone(tones, 396.0, 0.75);
        SayMyTextsUtils.genTone(tones, 440.0, 0.75);
        SayMyTextsUtils.genTone(tones, 495.0, 0.25);
        SayMyTextsUtils.genTone(tones, 528.0, 0.75);
        SayMyTextsUtils.genTone(tones, 495.0, 0.5);
        SayMyTextsUtils.genTone(tones, 495.0, 0.25);
        SayMyTextsUtils.genTone(tones, 594.0, 0.5);
        SayMyTextsUtils.finalizeSample(tones);
    }

    private static void genTone(List<Double> tones, double freqOfTone, double duration) {
        int numSample = (int)(duration * 8000.0);
        for (int i = 0; i < numSample; ++i) {
            tones.add(Math.sin(Math.PI * 2 * (double)tones.size() / (8000.0 / freqOfTone)));
        }
    }

    private static void finalizeSample(List<Double> tones) {
        boolean idx = false;
        for (double dVal : tones) {
            short val = (short)(dVal * 32767.0);
            FS_SONG_NOTES.add((byte)(val & 0xFF));
            FS_SONG_NOTES.add((byte)((val & 0xFF00) >>> 8));
        }
    }

    private static void playSound() {
        int size = FS_SONG_NOTES.size();
        final AudioTrack audioTrack = new AudioTrack(3, 8000, 4, 2, size, 0);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = FS_SONG_NOTES.get(i);
        }
        audioTrack.write(bytes, 0, size);
        audioTrack.setPlaybackPositionUpdateListener(new AudioTrack.OnPlaybackPositionUpdateListener(){

            public void onMarkerReached(AudioTrack track) {
            }

            public void onPeriodicNotification(AudioTrack track) {
                if (track.getPlayState() == 1) {
                    audioTrack.release();
                }
            }
        });
        audioTrack.play();
    }
}

