package org.chorem.android.saymytexts;

/*
 * #%L
 * Say My Texts
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.SwitchPreference;
import android.speech.tts.TextToSpeech;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;

/**
 * Activity to set settings
 *
 * @author Kevin Morin (Code Lutin)
 * @since 1.0
 */
public class SettingsActivity extends Activity {

    private static final String TAG = "SettingsActivity";

    protected static final int CHECK_TTS_REQUEST_CODE = 42;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        getFragmentManager().beginTransaction()
                .replace(android.R.id.content, new SettingsFragment())
                .commit();

        Intent checkIntent = new Intent();
        checkIntent.setAction(TextToSpeech.Engine.ACTION_CHECK_TTS_DATA);
        startActivityForResult(checkIntent, CHECK_TTS_REQUEST_CODE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == CHECK_TTS_REQUEST_CODE) {

            if (resultCode == TextToSpeech.Engine.CHECK_VOICE_DATA_FAIL) {
                Intent installIntent = new Intent(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
                startActivity(installIntent);
            }

        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static class SettingsFragment extends PreferenceFragment
                                 implements SharedPreferences.OnSharedPreferenceChangeListener {

        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);

            // Load the preferences from an XML resource
            addPreferencesFromResource(R.xml.preferences);

            Preference testPreference = findPreference(getString(R.string.preference_test_sms_key));
            testPreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {
                @Override
                public boolean onPreferenceClick(Preference preference) {
                    sendSMS();
                    return true;
                }
            });

            Context context = getActivity();
            try {
                String currentVersion = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
                Preference versionPreference = findPreference(getString(R.string.preference_version_key));
                versionPreference.setSummary(currentVersion);

            } catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "error while getting the version");
            }

            addWebsitePreferenceClickListener(R.string.preference_documentation_key);
            addWebsitePreferenceClickListener(R.string.preference_issue_tracker_key);

            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(getActivity());

            String key = getString(R.string.preference_reading_profile_key);
            ListPreference listPreference = (ListPreference) findPreference(key);
            CharSequence summary = listPreference.getEntry();
            listPreference.setSummary(summary);

            key = getString(R.string.preference_enable_interaction_key);
            SwitchPreference switchPreference = (SwitchPreference) findPreference(key);
            boolean enabled = SayMyTextsUtils.checkVoiceRecognition(context);
            switchPreference.setEnabled(enabled);
            boolean interactionEnabled = enabled && sharedPref.getBoolean(key, switchPreference.isChecked());
            switchPreference.setChecked(interactionEnabled);

            key = getString(R.string.preference_voice_recognizer_max_attempt_number_key);
            String maxAttemptValue = sharedPref.getString(key, null);
            int maxAttemptNumber;
            try {
                maxAttemptNumber = Integer.parseInt(maxAttemptValue);
            } catch (NumberFormatException e) {
                maxAttemptNumber = 3;
            }
            Preference preference = findPreference(key);
            preference.setSummary(String.valueOf(maxAttemptNumber));
            preference.setEnabled(interactionEnabled);

            key = getString(R.string.preference_enable_heisendroid_mode_key);
            switchPreference = (SwitchPreference) findPreference(key);
            interactionEnabled = sharedPref.getBoolean(key, switchPreference.isChecked());
            switchPreference.setChecked(interactionEnabled);

            sharedPref.registerOnSharedPreferenceChangeListener(this);
        }

        @Override
        public void onDestroy() {
            super.onDestroy();
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(getActivity());
            sharedPref.unregisterOnSharedPreferenceChangeListener(this);
        }

        @Override
        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {

            if (getString(R.string.preference_reading_profile_key).equals(key)) {
                ListPreference preference = (ListPreference) findPreference(key);
                CharSequence summary = preference.getEntry();
                preference.setSummary(summary);

            } else if (getString(R.string.preference_enable_interaction_key).equals(key)) {
                SwitchPreference switchPreference = (SwitchPreference) findPreference(key);
                boolean enabled = sharedPreferences.getBoolean(key, switchPreference.isChecked());
                switchPreference.setChecked(enabled);
                findPreference(getString(R.string.preference_voice_recognizer_max_attempt_number_key)).setEnabled(enabled);

            } else if (getString(R.string.preference_voice_recognizer_max_attempt_number_key).equals(key)) {
                String maxAttemptValue = sharedPreferences.getString(key, null);
                int maxAttemptNumber;
                try {
                    maxAttemptNumber = Integer.parseInt(maxAttemptValue);
                } catch (NumberFormatException e) {
                    maxAttemptNumber = 3;
                }
                findPreference(key).setSummary(String.valueOf(maxAttemptNumber));

            } else if (getString(R.string.preference_enable_heisendroid_mode_key).equals(key)) {
                SwitchPreference switchPreference = (SwitchPreference) findPreference(key);
                boolean enabled = sharedPreferences.getBoolean(key, switchPreference.isChecked());
                switchPreference.setChecked(enabled);
            }
        }

        protected void addWebsitePreferenceClickListener(int keyId) {
            Preference preference = findPreference(getString(keyId));
            preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {
                @Override
                public boolean onPreferenceClick(Preference preference) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(preference.getSummary().toString()));
                    startActivity(intent);
                    return true;
                }
            });
        }

        protected void sendSMS() {
            final Context context = getActivity();

            TelephonyManager tMgr = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            String phoneNumber = tMgr.getLine1Number();
            String message = getString(R.string.test_sms_content);

            PendingIntent pi = PendingIntent.getActivity(context, -1, new Intent(context, SettingsActivity.class), 0);
            SmsManager sms = SmsManager.getDefault();
            sms.sendTextMessage(phoneNumber, null, message, pi, null);

        }

    }
}
