/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.media.AudioManager;
import android.net.Uri;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.provider.ContactsContract;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SayMyTextService
extends Service
implements TextToSpeech.OnInitListener {
    private static final String TAG = "SayMyTextService";
    public static final String INTENT_EXTRA_SMS_BODY = "smsBody";
    public static final String INTENT_EXTRA_SMS_SENDER = "smsSender";
    public static final String INTENT_EXTRA_BT_DEVICE = "btDevice";
    public static final String INTENT_EXTRA_ADD_BT_DEVICE = "addBtDevice";
    protected static final String BT_UTTERANCE_ID = "btUtteranceId";
    protected static final String OTHER_UTTERANCE_ID = "otherUtteranceId";
    protected AudioManager audioManager;
    protected Boolean canSpeak = null;
    protected TextToSpeech textToSpeech;
    protected List<String> awaitingTexts = new ArrayList<String>();
    protected Map<BluetoothDevice, Integer> bluetoothDevices = new HashMap<BluetoothDevice, Integer>();
    protected final PhoneStateListener callStateListener = new PhoneStateListener(){

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            if (SayMyTextService.this.canSpeak != null) {
                SayMyTextService.this.setCanSpeak(state == 0);
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        this.textToSpeech = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
        this.audioManager = (AudioManager)this.getSystemService("audio");
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        tm.listen(this.callStateListener, 32);
    }

    public void onDestroy() {
        super.onDestroy();
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        tm.listen(this.callStateListener, 0);
        this.textToSpeech.shutdown();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int result = super.onStartCommand(intent, flags, startId);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String readingEnabledKey = this.getString(2131034112);
        boolean readingEnabled = sharedPref.getBoolean(readingEnabledKey, true);
        if (intent != null) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra(INTENT_EXTRA_BT_DEVICE);
            if (device != null) {
                boolean addBtDevice = intent.getBooleanExtra(INTENT_EXTRA_ADD_BT_DEVICE, false);
                if (addBtDevice) {
                    this.bluetoothDevices.put(device, device.getBluetoothClass().getDeviceClass());
                } else {
                    this.bluetoothDevices.remove(device);
                }
            } else if (readingEnabled && (this.audioManager.isWiredHeadsetOn() || !this.bluetoothDevices.isEmpty())) {
                String sms = intent.getStringExtra(INTENT_EXTRA_SMS_BODY);
                String sender = intent.getStringExtra(INTENT_EXTRA_SMS_SENDER);
                sender = this.getContactDisplayNameByNumber(sender);
                String text = this.getString(2131034120, new Object[]{sender, sms});
                if (this.canSpeak != null && this.canSpeak.booleanValue()) {
                    this.requestReading(text);
                } else {
                    this.awaitingTexts.add(text);
                }
            }
            result = 1;
        }
        return result;
    }

    public void onInit(int status) {
        if (status == 0) {
            this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

                public void onStart(String utteranceId) {
                }

                public void onError(String utteranceId) {
                    Log.e((String)SayMyTextService.TAG, (String)("Error speaking: " + utteranceId));
                }

                public void onDone(String utteranceId) {
                    if (SayMyTextService.BT_UTTERANCE_ID.equals(utteranceId)) {
                        SayMyTextService.this.audioManager.stopBluetoothSco();
                        SayMyTextService.this.audioManager.setMode(0);
                    }
                }
            });
            TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
            this.setCanSpeak(tm.getCallState() == 0);
        } else {
            this.setCanSpeak(null);
            this.textToSpeech = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
        }
    }

    protected void setCanSpeak(Boolean canSpeak) {
        this.canSpeak = canSpeak;
        if (canSpeak != null && canSpeak.booleanValue()) {
            this.requestReading(this.awaitingTexts);
            this.awaitingTexts.clear();
        }
    }

    protected void requestReading(String text) {
        this.requestReading(Collections.singletonList(text));
    }

    protected void requestReading(List<String> texts) {
        if (this.bluetoothDevices.isEmpty()) {
            this.readText(texts, false);
        } else {
            this.requestReadingOverBt(texts);
        }
    }

    protected void requestReadingOverBt(final List<String> texts) {
        this.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int state = intent.getExtras().getInt("android.media.extra.SCO_AUDIO_STATE");
                if (state == 1) {
                    context.unregisterReceiver((BroadcastReceiver)this);
                    SayMyTextService.this.readText(texts, true);
                }
            }
        }, new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"));
        this.audioManager.setMode(2);
        this.audioManager.startBluetoothSco();
    }

    protected void readText(List<String> texts, boolean btConnected) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("streamType", String.valueOf(0));
        params.put("utteranceId", btConnected ? BT_UTTERANCE_ID : OTHER_UTTERANCE_ID);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String heisendroidModeEnabledKey = this.getString(2131034113);
        boolean heisendroidModeEnabled = sharedPref.getBoolean(heisendroidModeEnabledKey, true);
        for (String text : texts) {
            if (heisendroidModeEnabled) {
                this.textToSpeech.setLanguage(Locale.US);
                this.textToSpeech.setSpeechRate(0.3f);
                this.textToSpeech.setPitch(0.1f);
                this.textToSpeech.speak("Say my text.", 1, params);
            }
            this.textToSpeech.setLanguage(Locale.getDefault());
            this.textToSpeech.setSpeechRate(1.0f);
            this.textToSpeech.setPitch(1.0f);
            this.textToSpeech.speak(text, 1, params);
            if (!heisendroidModeEnabled) continue;
            this.textToSpeech.setLanguage(Locale.US);
            this.textToSpeech.setSpeechRate(0.3f);
            this.textToSpeech.setPitch(0.1f);
            this.textToSpeech.speak("You're goddamn right.", 1, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContactDisplayNameByNumber(String number) {
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)number));
        String name = number;
        ContentResolver contentResolver = this.getContentResolver();
        try (Cursor contactLookup = contentResolver.query(uri, new String[]{"_id", "display_name"}, null, null, null);){
            if (contactLookup != null && contactLookup.getCount() > 0) {
                contactLookup.moveToNext();
                name = contactLookup.getString(contactLookup.getColumnIndex("display_name"));
            }
        }
        return name;
    }
}

