/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.telephony.SmsMessage;
import android.util.Log;
import org.chorem.android.saymytexts.SayMyTextService;

public class NewTextBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "NewTextBroadcastReceiver";

    public void onReceive(Context context, Intent intent) {
        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        Log.d((String)TAG, (String)"received");
        String action = intent.getAction();
        if ("android.provider.Telephony.SMS_RECEIVED".equals(action)) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                SmsMessage[] msgs = null;
                String messageReceived = "";
                Object[] pdus = (Object[])bundle.get("pdus");
                msgs = new SmsMessage[pdus.length];
                for (int i = 0; i < msgs.length; ++i) {
                    msgs[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
                    messageReceived = messageReceived + msgs[i].getDisplayMessageBody() + " ";
                }
                String senderPhoneNumber = msgs[0].getDisplayOriginatingAddress();
                Log.d((String)TAG, (String)messageReceived);
                serviceIntent.putExtra("smsBody", messageReceived);
                serviceIntent.putExtra("smsSender", senderPhoneNumber);
                context.startService(serviceIntent);
            }
        } else {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                int majorDeviceClass = device.getBluetoothClass().getMajorDeviceClass();
                if (majorDeviceClass == 1024) {
                    serviceIntent.putExtra("btDevice", (Parcelable)device);
                    serviceIntent.putExtra("addBtDevice", true);
                    context.startService(serviceIntent);
                }
            } else {
                serviceIntent.putExtra("btDevice", (Parcelable)device);
                serviceIntent.putExtra("addBtDevice", false);
                context.startService(serviceIntent);
            }
        }
    }
}

