package org.chorem.android.saymytexts;

/*
 * #%L
 * Say My Texts
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.SwitchPreference;
import android.speech.tts.TextToSpeech;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import java.util.Locale;

/**
 * Activity to set settings
 *
 * @author Kevin Morin (Code Lutin)
 * @since 1.0
 */
public class SettingsActivity extends Activity {

    private static final String TAG = "SettingsActivity";

    protected static final int CHECK_TTS_REQUEST_CODE = 42;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        getFragmentManager().beginTransaction()
                .replace(android.R.id.content, new SettingsFragment())
                .commit();

        Intent checkIntent = new Intent();
        checkIntent.setAction(TextToSpeech.Engine.ACTION_CHECK_TTS_DATA);
        startActivityForResult(checkIntent, CHECK_TTS_REQUEST_CODE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == CHECK_TTS_REQUEST_CODE) {

            if (resultCode == TextToSpeech.Engine.CHECK_VOICE_DATA_FAIL) {
                Intent installIntent = new Intent(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
                startActivity(installIntent);
            }

        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static class SettingsFragment extends PreferenceFragment {

        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);

            // Load the preferences from an XML resource
            addPreferencesFromResource(R.xml.preferences);

            Preference testPreference = findPreference(getString(R.string.preference_test_sms_key));
            testPreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener() {
                @Override
                public boolean onPreferenceClick(Preference preference) {
                    sendSMS();
                    return true;
                }
            });
        }

        @Override
        public void onResume() {
            super.onResume();

            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(getActivity());

            String key = getString(R.string.preference_enable_reading_key);
            SwitchPreference enableReadingPref = (SwitchPreference) getPreferenceScreen().findPreference(key);
            boolean enabled = sharedPref.getBoolean(key, enableReadingPref.isChecked());
            enableReadingPref.setChecked(enabled);

            key = getString(R.string.preference_enable_heisendroid_mode_key);
            enableReadingPref = (SwitchPreference) getPreferenceScreen().findPreference(key);
            enabled = sharedPref.getBoolean(key, enableReadingPref.isChecked());
            enableReadingPref.setChecked(enabled);
        }

        protected void sendSMS() {
            Context context = getActivity();

            TelephonyManager tMgr = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            String phoneNumber = tMgr.getLine1Number();
            String message = getString(R.string.test_sms_content);

            PendingIntent pi = PendingIntent.getActivity(context, -1, new Intent(context, SettingsActivity.class), 0);
            SmsManager sms = SmsManager.getDefault();
            sms.sendTextMessage(phoneNumber, null, message, pi, null);
        }
    }
}
