/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.util.AbstractSelectModel;
import org.chenillekit.tapestry.core.encoders.MultipleValueEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMultipleSelectModel<T>
extends AbstractSelectModel
implements MultipleValueEncoder<T> {
    private List<PropertyAdapter> _labelFieldAdapters = new ArrayList<PropertyAdapter>();
    private PropertyAdapter _idFieldAdapter;
    private List<T> _selectables;

    public GenericMultipleSelectModel(List<T> selectables, Class clasz, String labelPropertyName, String valuePropertyName, PropertyAccess access) {
        assert (InternalUtils.isNonBlank((String)labelPropertyName));
        this._selectables = selectables;
        if (valuePropertyName != null) {
            this._idFieldAdapter = access.getAdapter(clasz).getPropertyAdapter(valuePropertyName);
        }
        if (labelPropertyName != null) {
            String[] labels;
            for (String label : labels = labelPropertyName.split(",")) {
                this._labelFieldAdapters.add(access.getAdapter(clasz).getPropertyAdapter(label));
            }
        }
    }

    public List<OptionGroupModel> getOptionGroups() {
        return null;
    }

    public List<OptionModel> getOptions() {
        ArrayList<OptionModel> optionModelList = new ArrayList<OptionModel>();
        if (this._labelFieldAdapters.size() == 0) {
            for (T obj : this._selectables) {
                optionModelList.add((OptionModel)new OptionModelImpl(this.nvl(obj), obj));
            }
        } else {
            for (T obj : this._selectables) {
                String label = "";
                for (int i = 0; i < this._labelFieldAdapters.size(); ++i) {
                    PropertyAdapter propertyAdapter = this._labelFieldAdapters.get(i);
                    label = i > 0 ? label + "|" + this.nvl(propertyAdapter.get(obj)) : label + this.nvl(propertyAdapter.get(obj));
                }
                optionModelList.add((OptionModel)new OptionModelImpl(label, obj));
            }
        }
        return optionModelList;
    }

    @Override
    public String toClient(T obj) {
        if (this._idFieldAdapter == null) {
            return obj + "";
        }
        return this._idFieldAdapter.get(obj) + "";
    }

    @Override
    public List<T> toValue(String[] strings) {
        try {
            List<String> selectedList = Arrays.asList(strings);
            ArrayList<T> valueList = new ArrayList<T>();
            for (String selected : selectedList) {
                for (T value : this._selectables) {
                    if (!selected.equals(this._idFieldAdapter.get(value).toString())) continue;
                    valueList.add(value);
                }
            }
            return valueList;
        }
        catch (NullPointerException e) {
            return new ArrayList();
        }
    }

    private String nvl(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }
}

