/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.AfterRenderBody;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.chenillekit.tapestry.core.base.AbstractWindow;

public class Window
extends AbstractWindow {
    @Environmental
    private JavaScriptSupport javascriptSupport;
    private boolean hasBody = false;
    private String contentDivId;

    @BeforeRenderBody
    void beforeRenderBody(MarkupWriter writer) {
        this.contentDivId = this.javascriptSupport.allocateClientId(this.getClientId() + "Content");
        this.hasBody = true;
        writer.element("div", new Object[]{"id", this.contentDivId, "style", "display:none;"});
    }

    @AfterRenderBody
    void afterRenderBody(MarkupWriter writer) {
        writer.end();
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        JSONObject options = new JSONObject();
        options.put("className", (Object)this.getClassName());
        options.put("width", (Object)this.getWidth());
        options.put("height", (Object)this.getHeight());
        options.put("id", (Object)this.getClientId());
        options.put("title", (Object)this.getTitle());
        this.configure(options);
        JSONObject ckOptions = new JSONObject();
        ckOptions.put("windowoptions", (Object)options);
        ckOptions.put("hasbody", (Object)this.hasBody);
        ckOptions.put("show", (Object)this.isShow());
        ckOptions.put("center", (Object)this.isCenter());
        ckOptions.put("modal", (Object)this.isModal());
        ckOptions.put("clientid", (Object)this.getClientId());
        ckOptions.put("contentid", (Object)this.contentDivId);
        this.javascriptSupport.addInitializerCall("ckwindow", ckOptions);
    }
}

