/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.base;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.MarkupWriterListener;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public abstract class AbstractYahooComponent
implements ClientElement {
    private static final String YUI_CSS_CLASS = "yui-skin-sam";
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(value="false")
    private boolean disabled;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    @AfterRenderTemplate
    void afterRenderTemplate(final MarkupWriter writer) {
        writer.addListener(new MarkupWriterListener(){

            public void elementDidStart(Element element) {
                Element bodyElement = element.getDocument().find("html/body");
                if (bodyElement == null) {
                    return;
                }
                String cssClassValue = bodyElement.getAttribute("class");
                if (cssClassValue == null) {
                    bodyElement.attribute("class", AbstractYahooComponent.YUI_CSS_CLASS);
                } else if (!cssClassValue.contains(AbstractYahooComponent.YUI_CSS_CLASS)) {
                    bodyElement.addClassName(new String[]{AbstractYahooComponent.YUI_CSS_CLASS});
                }
                if (bodyElement.getAttribute("class") != null) {
                    writer.removeListener((MarkupWriterListener)this);
                }
            }

            public void elementDidEnd(Element element) {
            }
        });
    }

    public final String getClientId() {
        return this.assignedClientId;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

