/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class BCECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private boolean withCompression;
    private transient ECPoint q;
    private transient ECParameterSpec ecSpec;
    private transient ProviderConfiguration configuration;

    public BCECPublicKey(String string, BCECPublicKey bCECPublicKey) {
        this.algorithm = string;
        this.q = bCECPublicKey.q;
        this.ecSpec = bCECPublicKey.ecSpec;
        this.withCompression = bCECPublicKey.withCompression;
        this.configuration = bCECPublicKey.configuration;
    }

    public BCECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        this.configuration = providerConfiguration;
        if (eCPublicKeySpec.getParams() != null) {
            this.ecSpec = eCPublicKeySpec.getParams();
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
                this.q = eCParameterSpec.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public BCECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.configuration = providerConfiguration;
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    public BCECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = null;
        this.configuration = providerConfiguration;
    }

    BCECPublicKey(ECPublicKey eCPublicKey, ProviderConfiguration providerConfiguration) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
        this.configuration = providerConfiguration;
    }

    BCECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
        this.configuration = providerConfiguration;
    }

    BCECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo, ProviderConfiguration providerConfiguration) {
        this.configuration = providerConfiguration;
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    BCECPublicKey(String string, SubjectPublicKeyInfo subjectPublicKeyInfo, ProviderConfiguration providerConfiguration) {
        this.configuration = providerConfiguration;
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
        this.algorithm = string;
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        int n;
        ECCurve eCCurve;
        Object object;
        ASN1Object aSN1Object;
        X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Object = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
            object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1Object);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1Object), ((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH(), ((X9ECParameters)object).getSeed());
            eCCurve = this.ecSpec.getCurve();
        } else if (x962Parameters.isImplicitlyCA()) {
            this.ecSpec = null;
            eCCurve = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve();
        } else {
            aSN1Object = X9ECParameters.getInstance(x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Object).getCurve(), ((X9ECParameters)aSN1Object).getG(), ((X9ECParameters)aSN1Object).getN(), ((X9ECParameters)aSN1Object).getH(), ((X9ECParameters)aSN1Object).getSeed());
            eCCurve = this.ecSpec.getCurve();
        }
        aSN1Object = subjectPublicKeyInfo.getPublicKeyData();
        object = ((DERBitString)aSN1Object).getBytes();
        ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object);
        if (object[0] == 4 && object[1] == ((Object)object).length - 2 && (object[2] == 2 || object[2] == 3) && (n = new X9IntegerConverter().getByteLength(eCCurve)) >= ((Object)object).length - 3) {
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
        this.q = x9ECPoint.getPoint();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        Object object;
        Object object2;
        Object object3;
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            object3 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            if (object3 == null) {
                object3 = new ASN1ObjectIdentifier(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            }
            x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object3);
        } else if (this.ecSpec == null) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            object3 = this.ecSpec;
            object2 = ((ECParameterSpec)object3).getG().getCurve();
            object = ((ECCurve)object2).createPoint(((ECParameterSpec)object3).getG().getX().toBigInteger(), ((ECParameterSpec)object3).getG().getY().toBigInteger(), this.withCompression);
            X9ECParameters x9ECParameters = new X9ECParameters(((ECParameterSpec)object3).getCurve(), (ECPoint)object, ((ECParameterSpec)object3).getN(), ((ECParameterSpec)object3).getH(), ((ECParameterSpec)object3).getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        object3 = this.engineGetQ().getCurve();
        object2 = ((ECCurve)object3).createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression);
        object = ASN1OctetString.getInstance(new X9ECPoint((ECPoint)object2));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), ((ASN1OctetString)object).getOctets());
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECPublicKey)) {
            return false;
        }
        BCECPublicKey bCECPublicKey = (BCECPublicKey)object;
        return this.getQ().equals(bCECPublicKey.getQ()) && this.engineGetSpec().equals(bCECPublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
        this.configuration = BouncyCastleProvider.CONFIGURATION;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

