/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.denoise;

import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.alg.denoise.wavelet.DenoiseBayesShrink_F32;
import boofcv.alg.denoise.wavelet.DenoiseSureShrink_F32;
import boofcv.alg.denoise.wavelet.DenoiseVisuShrink_F32;
import boofcv.alg.denoise.wavelet.ShrinkThresholdSoft_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class FactoryDenoiseWaveletAlg {
    public static <T extends ImageGray<T>> DenoiseWavelet<T> bayes(@Nullable ShrinkThresholdRule<T> rule, Class<T> imageType) {
        if (rule == null) {
            rule = new ShrinkThresholdSoft_F32();
        }
        if (imageType == GrayF32.class) {
            return new DenoiseBayesShrink_F32(rule);
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType);
    }

    public static <T extends ImageGray<T>> DenoiseWavelet<T> sure(Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new DenoiseSureShrink_F32();
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType);
    }

    public static <T extends ImageGray<T>> DenoiseWavelet<T> visu(Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new DenoiseVisuShrink_F32();
        }
        throw new IllegalArgumentException("Unsupported image type " + imageType);
    }
}

