/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii.impl;

import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.alg.transform.ii.impl.ImplIntegralImageOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;

public class ImplIntegralImageConvolve {
    public static void convolve(GrayF32 integral, IntegralKernel kernel, GrayF32 output) {
        for (int y = 0; y < integral.height; ++y) {
            for (int x = 0; x < integral.width; ++x) {
                float total = 0.0f;
                for (int i = 0; i < kernel.blocks.length; ++i) {
                    ImageRectangle b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (float)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolveBorder(GrayF32 integral, IntegralKernel kernel, GrayF32 output, int borderX, int borderY) {
        int y;
        for (int x = 0; x < integral.width; ++x) {
            ImageRectangle b;
            int i;
            float total;
            for (y = 0; y < borderY; ++y) {
                total = 0.0f;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (float)kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (y = integral.height - borderY; y < integral.height; ++y) {
                total = 0.0f;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (float)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
        int endY = integral.height - borderY;
        for (y = borderY; y < endY; ++y) {
            ImageRectangle b;
            int i;
            int x;
            for (x = 0; x < borderX; ++x) {
                float total = 0.0f;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (float)kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (x = integral.width - borderX; x < integral.width; ++x) {
                float total = 0.0f;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (float)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(GrayS32 integral, IntegralKernel kernel, GrayS32 output) {
        for (int y = 0; y < integral.height; ++y) {
            for (int x = 0; x < integral.width; ++x) {
                int total = 0;
                for (int i = 0; i < kernel.blocks.length; ++i) {
                    ImageRectangle b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolveBorder(GrayS32 integral, IntegralKernel kernel, GrayS32 output, int borderX, int borderY) {
        int y;
        for (int x = 0; x < integral.width; ++x) {
            ImageRectangle b;
            int i;
            int total;
            for (y = 0; y < borderY; ++y) {
                total = 0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (y = integral.height - borderY; y < integral.height; ++y) {
                total = 0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
        int endY = integral.height - borderY;
        for (y = borderY; y < endY; ++y) {
            ImageRectangle b;
            int i;
            int total;
            int x;
            for (x = 0; x < borderX; ++x) {
                total = 0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (x = integral.width - borderX; x < integral.width; ++x) {
                total = 0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(GrayF64 integral, IntegralKernel kernel, GrayF64 output) {
        for (int y = 0; y < integral.height; ++y) {
            for (int x = 0; x < integral.width; ++x) {
                double total = 0.0;
                for (int i = 0; i < kernel.blocks.length; ++i) {
                    ImageRectangle b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (double)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolveBorder(GrayF64 integral, IntegralKernel kernel, GrayF64 output, int borderX, int borderY) {
        int y;
        for (int x = 0; x < integral.width; ++x) {
            ImageRectangle b;
            int i;
            double total;
            for (y = 0; y < borderY; ++y) {
                total = 0.0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (double)kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (y = integral.height - borderY; y < integral.height; ++y) {
                total = 0.0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (double)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
        int endY = integral.height - borderY;
        for (y = borderY; y < endY; ++y) {
            ImageRectangle b;
            int i;
            double total;
            int x;
            for (x = 0; x < borderX; ++x) {
                total = 0.0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (double)kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (x = integral.width - borderX; x < integral.width; ++x) {
                total = 0.0;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (double)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(GrayS64 integral, IntegralKernel kernel, GrayS64 output) {
        for (int y = 0; y < integral.height; ++y) {
            for (int x = 0; x < integral.width; ++x) {
                long total = 0L;
                for (int i = 0; i < kernel.blocks.length; ++i) {
                    ImageRectangle b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (long)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolveBorder(GrayS64 integral, IntegralKernel kernel, GrayS64 output, int borderX, int borderY) {
        int y;
        for (int x = 0; x < integral.width; ++x) {
            ImageRectangle b;
            int i;
            long total;
            for (y = 0; y < borderY; ++y) {
                total = 0L;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (long)kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (y = integral.height - borderY; y < integral.height; ++y) {
                total = 0L;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (long)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
        int endY = integral.height - borderY;
        for (y = borderY; y < endY; ++y) {
            ImageRectangle b;
            int i;
            long total;
            int x;
            for (x = 0; x < borderX; ++x) {
                total = 0L;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (long)kernel.scales[i];
                }
                output.set(x, y, total);
            }
            for (x = integral.width - borderX; x < integral.width; ++x) {
                total = 0L;
                for (i = 0; i < kernel.blocks.length; ++i) {
                    b = kernel.blocks[i];
                    total += ImplIntegralImageOps.block_zero(integral, x + b.x0, y + b.y0, x + b.x1, y + b.y1) * (long)kernel.scales[i];
                }
                output.set(x, y, total);
            }
        }
    }
}

