/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.text.DecimalFormat;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TIMETextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iHours;
    private int m_iMinutes;

    public TIMETextInformationID3V2Frame(int iHours, int iMinutes) throws ID3Exception {
        if (iHours < 0 || iHours > 24 || iMinutes < 0 || iMinutes > 59) {
            throw new ID3Exception("Hours and minutes must each be two digits or less.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        DecimalFormat oNF = new DecimalFormat("00");
        this.m_sInformation = oNF.format(iHours) + oNF.format(iMinutes);
        this.m_iHours = iHours;
        this.m_iMinutes = iMinutes;
    }

    public TIMETextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        byte[] abyInformation = null;
        try {
            abyInformation = this.m_sInformation.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a TIME frame in which the time digits cannot be parsed.", e);
        }
        if (abyInformation.length != 4) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TIME frame with time string length not equal to four.");
        }
        try {
            byte[] abyHours = new byte[]{abyInformation[0], abyInformation[1]};
            byte[] abyMinutes = new byte[]{abyInformation[2], abyInformation[3]};
            this.m_iHours = Integer.parseInt(new String(abyHours));
            this.m_iMinutes = Integer.parseInt(new String(abyMinutes));
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TIME frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTIMETextInformationID3V2Frame(this);
    }

    protected byte[] getFrameId() {
        return "TIME".getBytes();
    }

    public String toString() {
        return "Time (HHMM): [" + this.m_sInformation + "]";
    }

    public void setTime(int iHours, int iMinutes) throws ID3Exception {
        if (iHours < 0 || iHours > 24 || iMinutes < 0 || iMinutes > 59) {
            throw new ID3Exception("Hours and minutes must each be two digits or less.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        DecimalFormat oNF = new DecimalFormat("00");
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = oNF.format(iHours) + oNF.format(iMinutes);
        this.m_iHours = iHours;
        this.m_iMinutes = iMinutes;
    }

    public int getHours() {
        return this.m_iHours;
    }

    public int getMinutes() {
        return this.m_iMinutes;
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TIMETextInformationID3V2Frame)) {
            return false;
        }
        TIMETextInformationID3V2Frame oOtherTIME = (TIMETextInformationID3V2Frame)oOther;
        return this.m_iHours == oOtherTIME.m_iHours && this.m_iMinutes == oOtherTIME.m_iMinutes && this.m_oTextEncoding.equals(oOtherTIME.m_oTextEncoding) && this.m_sInformation.equals(oOtherTIME.m_sInformation);
    }
}

