/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class POSSID3V2Frame
extends ID3V2Frame {
    private TimestampFormat m_oTimestampFormat;
    private int m_iPosition;

    public POSSID3V2Frame(TimestampFormat oTimestampFormat, int iPosition) throws ID3Exception {
        if (oTimestampFormat == null) {
            throw new ID3Exception("Timestamp format required in POSS frame.");
        }
        this.m_oTimestampFormat = oTimestampFormat;
        if (iPosition < 0) {
            throw new ID3Exception("Position cannot be negative in POSS frame.");
        }
        this.m_iPosition = iPosition;
    }

    public POSSID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            byte[] abyPosition;
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTimestampFormat = new TimestampFormat((byte)oFrameDataID3DIS.readUnsignedByte());
            if (oFrameDataID3DIS.available() >= 1 && oFrameDataID3DIS.available() <= 4) {
                int i;
                abyPosition = new byte[4];
                for (i = 0; i < 4 - oFrameDataID3DIS.available(); ++i) {
                    abyPosition[i] = 0;
                }
                while (oFrameDataID3DIS.available() > 0) {
                    abyPosition[i] = (byte)oFrameDataID3DIS.readUnsignedByte();
                    ++i;
                }
            } else {
                throw new ID3Exception("Position value of " + oFrameDataID3DIS.available() + " bytes not supported in POSS frame.");
            }
            ByteArrayInputStream oBAIS = new ByteArrayInputStream(abyPosition);
            ID3DataInputStream oID3DIS = new ID3DataInputStream(oBAIS);
            this.m_iPosition = oID3DIS.readBE32();
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitPOSSID3V2Frame(this);
    }

    public void setPositionSynchronizationValue(TimestampFormat oTimestampFormat, int iPosition) throws ID3Exception {
        if (oTimestampFormat == null) {
            throw new ID3Exception("Timestamp format required in POSS frame.");
        }
        this.m_oTimestampFormat = oTimestampFormat;
        if (iPosition < 0) {
            throw new ID3Exception("Position cannot be negative in POSS frame.");
        }
        this.m_iPosition = iPosition;
    }

    public TimestampFormat getTimestampFormat() {
        return this.m_oTimestampFormat;
    }

    public int getPosition() {
        return this.m_iPosition;
    }

    protected byte[] getFrameId() {
        return "POSS".getBytes();
    }

    public String toString() {
        return "Position Synchronization: Timestamp format=[" + this.m_oTimestampFormat.getValue() + "], Position=[" + this.m_iPosition + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTimestampFormat.getValue());
        oIDOS.writeBE32(this.m_iPosition);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof POSSID3V2Frame)) {
            return false;
        }
        POSSID3V2Frame oOtherPOSS = (POSSID3V2Frame)oOther;
        return this.m_oTimestampFormat.equals(oOtherPOSS.m_oTimestampFormat) && this.m_iPosition == oOtherPOSS.m_iPosition;
    }

    public static class TimestampFormat {
        private byte m_byTimestampFormat;
        public static final TimestampFormat ABSOLUTE_MPEG_FRAMES = new TimestampFormat(1);
        public static final TimestampFormat ABSOLUTE_MILLISECONDS = new TimestampFormat(2);

        private TimestampFormat(byte byTimestampFormat) {
            this.m_byTimestampFormat = byTimestampFormat;
        }

        private byte getValue() {
            return this.m_byTimestampFormat;
        }

        public boolean equals(Object oOther) {
            try {
                TimestampFormat oOtherTF = (TimestampFormat)oOther;
                return this.m_byTimestampFormat == oOtherTF.m_byTimestampFormat;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

