/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class OWNEID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sPricePaid = null;
    private String m_sDateOfPurchase = null;
    private String m_sSeller = null;

    public OWNEID3V2Frame(String sPricePaid, String sDateOfPurchase, String sSeller) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sPricePaid == null) {
            throw new ID3Exception("Price paid required in OWNE frame.");
        }
        if (!sPricePaid.matches("(?uis)(\\w{3}\\d*\\.?\\d+/?)+")) {
            throw new ID3Exception("Invalid OWNE frame price string.");
        }
        this.m_sPricePaid = sPricePaid;
        if (sDateOfPurchase == null) {
            throw new ID3Exception("Date of purchase required in OWNE frame.");
        }
        if (!sDateOfPurchase.matches("(?uis)\\d{8}")) {
            throw new ID3Exception("Invalid date of purchase format in OWNE frame.");
        }
        this.m_sDateOfPurchase = sDateOfPurchase;
        if (sSeller == null) {
            throw new ID3Exception("Seller required in OWNE frame.");
        }
        this.m_sSeller = sSeller;
    }

    public OWNEID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            this.m_sPricePaid = oFrameDataID3DIS.readStringToNull();
            byte[] abyDateOfPurchase = new byte[8];
            oFrameDataID3DIS.readFully(abyDateOfPurchase);
            this.m_sDateOfPurchase = new String(abyDateOfPurchase);
            byte[] abySeller = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abySeller);
            this.m_sSeller = new String(abySeller, this.m_oTextEncoding.getEncodingString());
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitOWNEID3V2Frame(this);
    }

    public void setOwnershipInformation(String sPricePaid, String sDateOfPurchase, String sSeller) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sPricePaid == null) {
            throw new ID3Exception("Price paid required in OWNE frame.");
        }
        if (!sPricePaid.matches("(?uis)(\\w{3}\\d*\\.?\\d+/?)+")) {
            throw new ID3Exception("Invalid OWNE frame price paid string.");
        }
        this.m_sPricePaid = sPricePaid;
        if (sDateOfPurchase == null) {
            throw new ID3Exception("Date of purchase required in OWNE frame.");
        }
        if (!sDateOfPurchase.matches("(?uis)\\d{8}")) {
            throw new ID3Exception("Invalid OWNE frame date of purchase.");
        }
        this.m_sDateOfPurchase = sDateOfPurchase;
        if (sSeller == null) {
            throw new ID3Exception("Seller required in OWNE frame.");
        }
        this.m_sSeller = sSeller;
    }

    public String getPricePaid() {
        return this.m_sPricePaid;
    }

    public String getDateOfPurchase() {
        return this.m_sDateOfPurchase;
    }

    public String getSeller() {
        return this.m_sSeller;
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "OWNE".getBytes();
    }

    public String toString() {
        return "Ownership Frame: Price paid=[" + this.m_sPricePaid + "], Date of purchase=[" + this.m_sDateOfPurchase + "], Seller=[" + this.m_sSeller + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sPricePaid.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.write(this.m_sDateOfPurchase.getBytes());
        oIDOS.write(this.m_sSeller.getBytes(this.m_oTextEncoding.getEncodingString()));
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof OWNEID3V2Frame)) {
            return false;
        }
        OWNEID3V2Frame oOtherOWNE = (OWNEID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherOWNE.m_oTextEncoding) && this.m_sPricePaid.equals(oOtherOWNE.m_sPricePaid) && this.m_sDateOfPurchase.equals(oOtherOWNE.m_sDateOfPurchase) && this.m_sSeller.equals(oOtherOWNE.m_sSeller);
    }
}

