/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.ant;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.swing.image.ImageFileWriter;
import org.assertj.swing.junit.ant.ImageDecoder;
import org.assertj.swing.junit.ant.ImageEncoder;
import org.assertj.swing.util.Strings;

public final class ImageHandler {
    private static final String EMPTY_STRING = "";
    private static Logger logger = Logger.getAnonymousLogger();
    private static ImageEncoder imageEncoder = new ImageEncoder();
    private static ImageDecoder imageDecoder = new ImageDecoder();
    private static ImageFileWriter imageFileWriter = new ImageFileWriter();

    public static String encodeBase64(BufferedImage image) {
        return ImageHandler.encodeBase64(image, imageEncoder);
    }

    static String encodeBase64(BufferedImage image, ImageEncoder encoder) {
        try {
            return encoder.encodeBase64(image);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to encode image", e);
            return null;
        }
    }

    public static BufferedImage decodeBase64(String encoded) {
        return ImageHandler.decodeBase64(encoded, imageDecoder);
    }

    static BufferedImage decodeBase64(String encoded, ImageDecoder decoder) {
        try {
            return decoder.decodeBase64(encoded);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to encode image", e);
            return null;
        }
    }

    public static String decodeBase64AndSaveAsPng(String encoded, String path) {
        return ImageHandler.decodeBase64AndSaveAsPng(encoded, path, imageDecoder, imageFileWriter);
    }

    static String decodeBase64AndSaveAsPng(String encoded, String path, ImageDecoder decoder, ImageFileWriter writer) {
        if (Strings.isNullOrEmpty((String)encoded)) {
            return EMPTY_STRING;
        }
        if (Strings.isNullOrEmpty((String)path)) {
            return EMPTY_STRING;
        }
        String realPath = path.replace("/", File.separator);
        BufferedImage image = ImageHandler.decodeBase64(encoded, decoder);
        try {
            writer.writeAsPng(image, realPath);
        }
        catch (Exception ignored) {
            logger.log(Level.SEVERE, ignored.getMessage());
        }
        return EMPTY_STRING;
    }

    private ImageHandler() {
    }
}

