/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.wsdl20.extensions.rpc.Argument;
import org.apache.woden.wsdl20.extensions.rpc.Direction;
import org.apache.woden.xml.ArgumentArrayAttr;

public class ArgumentArrayAttrImpl
extends XMLAttrImpl
implements ArgumentArrayAttr {
    public ArgumentArrayAttrImpl(XMLElement ownerEl, QName attrType, String attrValue, ErrorReporter errRpt) throws WSDLException {
        super(ownerEl, attrType, attrValue, errRpt);
    }

    public Argument[] getArgumentArray() {
        return (Argument[])this.getContent();
    }

    protected Object convert(XMLElement ownerEl, String attrValue) throws WSDLException {
        List tokens;
        int length;
        this.setValid(false);
        if (attrValue != null && (length = (tokens = StringUtils.parseNMTokens(attrValue)).size()) % 2 == 0) {
            int argc = length / 2;
            Argument[] args = new Argument[argc];
            Iterator i = tokens.iterator();
            for (int j = 0; j < argc; ++j) {
                String qnameStr = (String)i.next();
                QName qname = this.convertQName(ownerEl, qnameStr);
                if (qname == null) {
                    return null;
                }
                String directionStr = (String)i.next();
                Direction direction = this.convertDirection(directionStr);
                if (direction == null) {
                    return null;
                }
                args[j] = new Argument(qname, direction);
            }
            this.setValid(true);
            return args;
        }
        this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{attrValue}, (short)2, (Exception)new IllegalArgumentException());
        return null;
    }

    private QName convertQName(XMLElement ownerEl, String qnameStr) throws WSDLException {
        QName qname = null;
        try {
            qname = ownerEl.getQName(qnameStr);
        }
        catch (WSDLException e) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{qnameStr}, (short)2, (Exception)((Object)e));
        }
        return qname;
    }

    private Direction convertDirection(String directionStr) throws WSDLException {
        Direction[] directions = new Direction[]{Direction.IN, Direction.INOUT, Direction.OUT, Direction.RETURN};
        for (int i = 0; i < directions.length; ++i) {
            if (!directionStr.equals(directions[i].toString())) continue;
            return directions[i];
        }
        this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{directionStr}, (short)2, (Exception)new IllegalArgumentException());
        return null;
    }
}

