/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.grid;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.DataViewBase;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.util.ArrayIteratorAdapter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataGridView<T>
extends DataViewBase<T> {
    private static final long serialVersionUID = 1L;
    private static final String CELL_REPEATER_ID = "cells";
    private static final String CELL_ITEM_ID = "cell";
    private final ICellPopulator<T>[] populators;
    private transient ArrayIteratorAdapter<ICellPopulator<T>> populatorsIteratorCache;

    public AbstractDataGridView(String id, ICellPopulator<T>[] populators, IDataProvider<T> dataProvider) {
        super(id, dataProvider);
        this.populators = populators;
    }

    private ArrayIteratorAdapter<ICellPopulator<T>> getPopulatorsIterator() {
        if (this.populatorsIteratorCache == null) {
            this.populatorsIteratorCache = new ArrayIteratorAdapter<ICellPopulator<T>>(this.internalGetPopulators()){

                protected IModel<ICellPopulator<T>> model(ICellPopulator<T> object) {
                    return new Model(object);
                }
            };
        } else {
            this.populatorsIteratorCache.reset();
        }
        return this.populatorsIteratorCache;
    }

    protected final ICellPopulator<T>[] internalGetPopulators() {
        return this.populators;
    }

    protected Item<ICellPopulator<T>> newCellItem(String id, int index, IModel<ICellPopulator<T>> model) {
        return new Item(id, index, model);
    }

    protected final Item<T> newItem(String id, int index, IModel<T> model) {
        return this.newRowItem(id, index, model);
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new Item(id, index, model);
    }

    protected void onDetach() {
        super.onDetach();
        if (this.populators != null) {
            for (int i = 0; i < this.populators.length; ++i) {
                this.populators[i].detach();
            }
        }
    }

    protected final void populateItem(Item<T> item) {
        RepeatingView cells = new RepeatingView(CELL_REPEATER_ID);
        item.add(new Component[]{cells});
        ArrayIteratorAdapter<ICellPopulator<T>> populators = this.getPopulatorsIterator();
        int i = 0;
        while (populators.hasNext()) {
            IModel populatorModel = populators.next();
            Item<ICellPopulator<T>> cellItem = this.newCellItem(cells.newChildId(), i, populatorModel);
            cells.add(new Component[]{cellItem});
            ICellPopulator populator = (ICellPopulator)cellItem.getModelObject();
            populator.populateItem(cellItem, CELL_ITEM_ID, item.getModel());
            if (cellItem.get(CELL_ITEM_ID) == null) {
                throw new WicketRuntimeException(populator.getClass().getName() + ".populateItem() failed to add a component with id [" + CELL_ITEM_ID + "] to the provided [cellItem] object. Make sure you call add() on cellItem and make sure you gave the added component passed in 'componentId' id. ( *cellItem*.add(new MyComponent(*componentId*, rowModel) )");
            }
            ++i;
        }
    }
}

