/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.console;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.vysper.console.AdHocCommandDataBuilder;
import org.apache.vysper.console.ExtendedXMPPConnection;
import org.apache.vysper.console.HtmlFormBuilder;
import org.apache.vysper.console.ResourceNotFoundException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.packet.AdHocCommandData;
import org.jivesoftware.smackx.packet.DataForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdminConsoleController {
    private static final String MODEL_AUTHENTICATED = "authenticated";
    public static final String SESSION_ATTRIBUTE = "smack.client";
    public static final String SESSION_FIELD = "vysper-admingui-sessionid";
    public static final Map<String, String> COMMANDS = new HashMap();
    private ConnectionConfiguration connectionConfiguration;
    private AdHocCommandDataBuilder adHocCommandDataBuilder = new AdHocCommandDataBuilder();
    private HtmlFormBuilder htmlFormBuilder = new HtmlFormBuilder();

    @Autowired
    public AdminConsoleController(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    @RequestMapping(value={"/"})
    public ModelAndView index(HttpSession session) throws XMPPException {
        ExtendedXMPPConnection client = (ExtendedXMPPConnection)session.getAttribute(SESSION_ATTRIBUTE);
        if (client == null) {
            return this.login();
        }
        if (!client.isConnected()) {
            return this.login("Disconnected from XMPP server, please log in again");
        }
        ModelAndView mav = new ModelAndView("index");
        mav.addObject(MODEL_AUTHENTICATED, (Object)this.getUserName((XMPPConnection)client));
        return mav;
    }

    private String getUserName(XMPPConnection client) {
        EntityImpl entity = EntityImpl.parseUnchecked((String)client.getUser());
        return entity.getBareJID().getFullQualifiedName();
    }

    @RequestMapping(value={"/{command}"}, method={RequestMethod.GET})
    public ModelAndView command(@PathVariable(value="command") String command, HttpSession session) throws XMPPException {
        ExtendedXMPPConnection client = (ExtendedXMPPConnection)session.getAttribute(SESSION_ATTRIBUTE);
        if (client == null) {
            return this.login();
        }
        if (!client.isConnected()) {
            return this.login("Disconnected from XMPP server, please log in again");
        }
        if (!COMMANDS.keySet().contains(command)) {
            throw new ResourceNotFoundException();
        }
        AdHocCommandData requestCommand = new AdHocCommandData();
        requestCommand.setType(IQ.Type.SET);
        requestCommand.setFrom(client.getUser());
        requestCommand.setTo(client.getServiceName());
        requestCommand.setAction(AdHocCommand.Action.execute);
        requestCommand.setNode("http://jabber.org/protocol/admin#" + command);
        return this.sendRequestAndGenerateForm(command, client, requestCommand);
    }

    @RequestMapping(value={"/{command}"}, method={RequestMethod.POST})
    public ModelAndView submitCommand(@PathVariable(value="command") String command, HttpServletRequest request, HttpSession session) throws XMPPException {
        ExtendedXMPPConnection client = (ExtendedXMPPConnection)session.getAttribute(SESSION_ATTRIBUTE);
        if (client == null) {
            return this.login();
        }
        if (!client.isConnected()) {
            return this.login("Disconnected from XMPP server, please log in again");
        }
        AdHocCommandData requestCommand = this.adHocCommandDataBuilder.build(request.getParameterMap());
        requestCommand.setType(IQ.Type.SET);
        requestCommand.setFrom(client.getUser());
        requestCommand.setTo(client.getServiceName());
        requestCommand.setNode("http://jabber.org/protocol/admin#" + command);
        return this.sendRequestAndGenerateForm(command, client, requestCommand);
    }

    private ModelAndView sendRequestAndGenerateForm(String command, ExtendedXMPPConnection client, AdHocCommandData requestCommand) {
        try {
            Packet response = client.sendSync((Packet)requestCommand);
            StringBuffer htmlForm = new StringBuffer();
            if (response != null) {
                AdHocCommandData responseData = (AdHocCommandData)response;
                DataForm form = responseData.getForm();
                for (AdHocCommandNote note : responseData.getNotes()) {
                    htmlForm.append("<p class='note " + note.getType() + "'>" + note.getValue() + "</p>");
                }
                htmlForm.append("<form action='' method='post'>");
                htmlForm.append("<input type='hidden' name='vysper-admingui-sessionid' value='" + responseData.getSessionID() + "' />");
                htmlForm.append(this.htmlFormBuilder.build(form));
                if (AdHocCommand.Status.executing.equals((Object)responseData.getStatus())) {
                    htmlForm.append("<input type='submit' value='" + (String)COMMANDS.get(command) + "' />");
                } else if (AdHocCommand.Status.completed.equals((Object)responseData.getStatus()) && (form == null || form.getFields() == null || !form.getFields().hasNext())) {
                    htmlForm.append("<p>Command successful</p>");
                }
                htmlForm.append("</form>");
            } else {
                htmlForm.append("<p class='note error'>Timeout waiting for response from XMPP server</p>");
            }
            ModelAndView mav = new ModelAndView("command");
            mav.addObject(MODEL_AUTHENTICATED, (Object)this.getUserName((XMPPConnection)client));
            mav.addObject("form", (Object)htmlForm.toString());
            return mav;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private ModelAndView login() {
        return this.login("Please log in");
    }

    private ModelAndView login(String msg) {
        ModelAndView mav = new ModelAndView("index");
        mav.addObject("message", (Object)msg);
        return mav;
    }

    protected ExtendedXMPPConnection createXMPPConnection() {
        return new ExtendedXMPPConnection(this.connectionConfiguration);
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public ModelAndView login(@RequestParam(value="username") String username, @RequestParam(value="password") String password, HttpSession session) {
        ExtendedXMPPConnection client = this.createXMPPConnection();
        try {
            client.connect();
            client.login(username, password);
            session.setAttribute(SESSION_ATTRIBUTE, (Object)client);
            return new ModelAndView("redirect:");
        }
        catch (XMPPException e) {
            ModelAndView mav = new ModelAndView("index");
            mav.addObject("error", (Object)("Failed to login to server: " + e.getMessage()));
            return mav;
        }
    }

    @RequestMapping(value={"/logout"})
    public ModelAndView logout(HttpSession session) {
        ExtendedXMPPConnection client = (ExtendedXMPPConnection)session.getAttribute(SESSION_ATTRIBUTE);
        if (client != null) {
            client.disconnect();
            session.removeAttribute(SESSION_ATTRIBUTE);
        }
        return new ModelAndView("redirect:");
    }

    static {
        COMMANDS.put("get-online-users-num", "Get online users");
        COMMANDS.put("add-user", "Add user");
        COMMANDS.put("change-user-password", "Change user password");
    }
}

