/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TXTParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        String encoding;
        MediaType mt;
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        CharsetDetector detector = new CharsetDetector();
        String incomingCharset = metadata.get("Content-Encoding");
        String incomingType = metadata.get("Content-Type");
        if (incomingCharset == null && incomingType != null && (mt = MediaType.parse((String)incomingType)) != null) {
            incomingCharset = (String)mt.getParameters().get("charset");
        }
        if (incomingCharset != null) {
            detector.setDeclaredEncoding(incomingCharset);
        }
        detector.setText(stream);
        for (CharsetMatch match : detector.detectAll()) {
            if (!Charset.isSupported(match.getName())) continue;
            metadata.set("Content-Encoding", match.getName());
            String language = match.getLanguage();
            if (language == null) break;
            metadata.add("Content-Language", language);
            metadata.add("language", language);
            break;
        }
        if ((encoding = metadata.get("Content-Encoding")) == null) {
            throw new TikaException("Text encoding could not be detected and no encoding hint is available in document metadata");
        }
        metadata.set("Content-Type", "text/plain");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));
            ((Reader)reader).mark(1);
            int bom = ((Reader)reader).read();
            if (bom != 65279) {
                ((Reader)reader).reset();
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.startElement("p");
            char[] buffer = new char[4096];
            int n = reader.read(buffer);
            while (n != -1) {
                xhtml.characters(buffer, 0, n);
                n = reader.read(buffer);
            }
            xhtml.endElement("p");
            xhtml.endDocument();
        }
        catch (UnsupportedEncodingException e) {
            throw new TikaException("Unsupported text encoding: " + encoding, (Throwable)e);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

