/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.planner.util;

import lombok.Generated;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.shardingsphere.infra.autogen.version.ShardingSphereVersion;

public final class SQLFederationFunctionUtils {
    private static final int DEFAULT_PASSWORD_DEADLINE = 90;
    private static final int DEFAULT_PASSWORD_NOTIFY_TIME = 7;

    public static void registryUserDefinedFunction(String schemaName, SchemaPlus schemaPlus) {
        schemaPlus.add("version", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"version"));
        schemaPlus.add("opengauss_version", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"openGaussVersion"));
        schemaPlus.add("gs_password_deadline", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"gsPasswordDeadline"));
        schemaPlus.add("intervaltonum", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"intervalToNum"));
        schemaPlus.add("gs_password_notifyTime", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"gsPasswordNotifyTime"));
        schemaPlus.add("pg_catalog.gs_password_deadline", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"gsPasswordDeadline"));
        schemaPlus.add("pg_catalog.intervaltonum", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"intervalToNum"));
        schemaPlus.add("pg_catalog.gs_password_notifyTime", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"gsPasswordNotifyTime"));
        if ("pg_catalog".equalsIgnoreCase(schemaName)) {
            schemaPlus.add("pg_catalog.pg_table_is_visible", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"pgTableIsVisible"));
            schemaPlus.add("pg_catalog.pg_get_userbyid", (Function)ScalarFunctionImpl.create(SQLFederationFunctionUtils.class, (String)"pgGetUserById"));
        }
    }

    public static boolean pgTableIsVisible(Long oid) {
        return true;
    }

    public static String pgGetUserById(Long oid) {
        return "mock user";
    }

    public static String version() {
        return "ShardingSphere-Proxy 5.5.0" + "-" + ShardingSphereVersion.BUILD_GIT_COMMIT_ID_ABBREV + (ShardingSphereVersion.BUILD_GIT_DIRTY ? "-dirty" : "");
    }

    public static String openGaussVersion() {
        return "5.5.0";
    }

    public static int gsPasswordDeadline() {
        return 90;
    }

    public static int intervalToNum(int result) {
        return result;
    }

    public static int gsPasswordNotifyTime() {
        return 7;
    }

    @Generated
    private SQLFederationFunctionUtils() {
    }
}

