/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public class AggregationProjectionSegment
implements ProjectionSegment,
AliasAvailable,
ExpressionSegment {
    private final int startIndex;
    private final int stopIndex;
    private final AggregationType type;
    private final String expression;
    private final Collection<ExpressionSegment> parameters = new LinkedList<ExpressionSegment>();
    private AliasSegment alias;

    public AggregationProjectionSegment(int startIndex, int stopIndex, AggregationType type, String expression) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.type = type;
        this.expression = expression;
    }

    @Override
    public String getColumnLabel() {
        return this.getAliasName().orElse(this.expression);
    }

    @Override
    public final Optional<String> getAliasName() {
        return null == this.alias ? Optional.empty() : Optional.ofNullable(this.alias.getIdentifier().getValue());
    }

    @Override
    public final Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias).map(AliasSegment::getIdentifier);
    }

    @Override
    public String getText() {
        return this.expression;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public AggregationType getType() {
        return this.type;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public Collection<ExpressionSegment> getParameters() {
        return this.parameters;
    }

    @Override
    @Generated
    public void setAlias(AliasSegment alias) {
        this.alias = alias;
    }
}

