/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.driver.executor.callback.ExecuteQueryCallback;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.connection.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class DriverJDBCExecutor {
    private final String databaseName;
    private final MetaDataContexts metaDataContexts;
    private final ModeContextManager modeContextManager;
    private final JDBCExecutor jdbcExecutor;
    private final ProcessEngine processEngine = new ProcessEngine();

    public DriverJDBCExecutor(String databaseName, ContextManager contextManager, JDBCExecutor jdbcExecutor) {
        this.databaseName = databaseName;
        this.jdbcExecutor = jdbcExecutor;
        this.metaDataContexts = contextManager.getMetaDataContexts();
        this.modeContextManager = contextManager.getInstanceContext().getModeContextManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryResult> executeQuery(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, QueryContext queryContext, ExecuteQueryCallback callback) throws SQLException {
        try {
            this.processEngine.executeSQL(executionGroupContext, queryContext);
            List list = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)callback);
            return list;
        }
        finally {
            this.processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, QueryContext queryContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Integer> callback) throws SQLException {
        try {
            this.processEngine.executeSQL(executionGroupContext, queryContext);
            SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
            List<Integer> results = this.doExecute(executionGroupContext, sqlStatementContext, routeUnits, callback);
            int n = this.isNeedAccumulate(this.metaDataContexts.getMetaData().getDatabase(queryContext.getDatabaseNameFromSQLStatement().orElse(this.databaseName)).getRuleMetaData().getRules(), sqlStatementContext) ? this.accumulate(results) : results.get(0).intValue();
            return n;
        }
        finally {
            this.processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    private boolean isNeedAccumulate(Collection<ShardingSphereRule> rules, SQLStatementContext sqlStatementContext) {
        for (ShardingSphereRule each : rules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(DataNodeRuleAttribute.class);
            if (!ruleAttribute.isPresent() || !((DataNodeRuleAttribute)ruleAttribute.get()).isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    private int accumulate(List<Integer> updateResults) {
        int result = 0;
        for (Integer each : updateResults) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, QueryContext queryContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Boolean> callback) throws SQLException {
        try {
            this.processEngine.executeSQL(executionGroupContext, queryContext);
            List<Boolean> results = this.doExecute(executionGroupContext, queryContext.getSqlStatementContext(), routeUnits, callback);
            boolean bl = null != results && !results.isEmpty() && null != results.get(0) && results.get(0) != false;
            return bl;
        }
        finally {
            this.processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    private <T> List<T> doExecute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, SQLStatementContext sqlStatementContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<T> callback) throws SQLException {
        List results = this.jdbcExecutor.execute(executionGroupContext, callback);
        new MetaDataRefreshEngine(this.modeContextManager, this.metaDataContexts.getMetaData().getDatabase(sqlStatementContext.getTablesContext().getDatabaseName().orElse(this.databaseName)), this.metaDataContexts.getMetaData().getProps()).refresh(sqlStatementContext, routeUnits);
        return results;
    }
}

