/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class AlterViewStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;

    public AlterViewStatementContext(AlterViewStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        LinkedList<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
        tables.add(sqlStatement.getView());
        Optional selectStatement = AlterViewStatementHandler.getSelectStatement((AlterViewStatement)sqlStatement);
        selectStatement.ifPresent(optional -> {
            TableExtractor extractor = new TableExtractor();
            extractor.extractTablesFromSelect(optional);
            tables.addAll(extractor.getRewriteTables());
        });
        AlterViewStatementHandler.getRenameView((AlterViewStatement)sqlStatement).ifPresent(tables::add);
        this.tablesContext = new TablesContext(tables, this.getDatabaseType());
    }

    public AlterViewStatement getSqlStatement() {
        return (AlterViewStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getSimpleTableSegments();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

