/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.record.DocumentEncryptionAtom;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.PositionDependentRecordAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptor;
import org.apache.poi.util.BitField;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public class HSLFSlideShowEncrypted {
    DocumentEncryptionAtom dea;
    CryptoAPIEncryptor enc = null;
    CryptoAPIDecryptor dec = null;
    Cipher cipher = null;
    CipherOutputStream cyos = null;
    private static final BitField fieldRecInst = new BitField(65520);

    protected HSLFSlideShowEncrypted(DocumentEncryptionAtom dea) {
        this.dea = dea;
    }

    protected HSLFSlideShowEncrypted(byte[] docstream, NavigableMap<Integer, Record> recordMap) {
        UserEditAtom userEditAtomWithEncryption = null;
        for (Map.Entry me : recordMap.descendingMap().entrySet()) {
            UserEditAtom uea;
            Record r = (Record)me.getValue();
            if (!(r instanceof UserEditAtom) || (uea = (UserEditAtom)r).getEncryptSessionPersistIdRef() == -1) continue;
            userEditAtomWithEncryption = uea;
            break;
        }
        if (userEditAtomWithEncryption == null) {
            this.dea = null;
            return;
        }
        Record r = (Record)recordMap.get(userEditAtomWithEncryption.getPersistPointersOffset());
        assert (r instanceof PersistPtrHolder);
        PersistPtrHolder ptr = (PersistPtrHolder)r;
        Integer encOffset = ptr.getSlideLocationsLookup().get(userEditAtomWithEncryption.getEncryptSessionPersistIdRef());
        if (encOffset == null) {
            this.dea = null;
            return;
        }
        r = (Record)recordMap.get(encOffset);
        if (r == null) {
            r = Record.buildRecordAtOffset(docstream, encOffset);
            recordMap.put(encOffset, r);
        }
        assert (r instanceof DocumentEncryptionAtom);
        this.dea = (DocumentEncryptionAtom)r;
        this.decryptInit();
        String pass = Biff8EncryptionKey.getCurrentUserPassword();
        if (!this.dec.verifyPassword(pass != null ? pass : "VelvetSweatshop")) {
            throw new EncryptedPowerPointFileException("PowerPoint file is encrypted. The correct password needs to be set via Biff8EncryptionKey.setCurrentUserPassword()");
        }
    }

    public DocumentEncryptionAtom getDocumentEncryptionAtom() {
        return this.dea;
    }

    protected void setPersistId(int persistId) {
        if (this.enc != null && this.dec != null) {
            throw new EncryptedPowerPointFileException("Use instance either for en- or decryption");
        }
        try {
            if (this.enc != null) {
                this.cipher = this.enc.initCipherForBlock(this.cipher, persistId);
            }
            if (this.dec != null) {
                this.cipher = this.dec.initCipherForBlock(this.cipher, persistId);
            }
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedPowerPointFileException(e);
        }
    }

    protected void decryptInit() {
        if (this.dec != null) {
            return;
        }
        EncryptionInfo ei = this.dea.getEncryptionInfo();
        this.dec = (CryptoAPIDecryptor)ei.getDecryptor();
    }

    protected void encryptInit() {
        if (this.enc != null) {
            return;
        }
        EncryptionInfo ei = this.dea.getEncryptionInfo();
        this.enc = (CryptoAPIEncryptor)ei.getEncryptor();
    }

    protected OutputStream encryptRecord(OutputStream plainStream, int persistId, Record record) {
        boolean isPlain;
        boolean bl = isPlain = this.dea == null || record instanceof UserEditAtom || record instanceof PersistPtrHolder || record instanceof DocumentEncryptionAtom;
        if (isPlain) {
            return plainStream;
        }
        this.encryptInit();
        this.setPersistId(persistId);
        if (this.cyos == null) {
            this.cyos = new CipherOutputStream(plainStream, this.cipher);
        }
        return this.cyos;
    }

    protected void decryptRecord(byte[] docstream, int persistId, int offset) {
        if (this.dea == null) {
            return;
        }
        this.decryptInit();
        this.setPersistId(persistId);
        try {
            this.cipher.update(docstream, offset, 8, docstream, offset);
            int rlen = (int)LittleEndian.getUInt((byte[])docstream, (int)(offset + 4));
            this.cipher.update(docstream, offset + 8, rlen, docstream, offset + 8);
        }
        catch (GeneralSecurityException e) {
            throw new CorruptPowerPointFileException(e);
        }
    }

    protected void decryptPicture(byte[] pictstream, int offset) {
        if (this.dea == null) {
            return;
        }
        this.decryptInit();
        this.setPersistId(0);
        try {
            this.cipher.doFinal(pictstream, offset, 8, pictstream, offset);
            int recInst = fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
            int recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
            int rlen = (int)LittleEndian.getUInt((byte[])pictstream, (int)(offset + 4));
            int endOffset = (offset += 8) + rlen;
            if (recType == 61447) {
                this.cipher.doFinal(pictstream, offset, 1, pictstream, offset);
                this.cipher.doFinal(pictstream, ++offset, 1, pictstream, offset);
                this.cipher.doFinal(pictstream, ++offset, 16, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 16, 2, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 2, 4, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 4, 4, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 4, 4, pictstream, offset);
                this.cipher.doFinal(pictstream, (offset += 4) + 0, 1, pictstream, offset + 0);
                this.cipher.doFinal(pictstream, offset + 1, 1, pictstream, offset + 1);
                this.cipher.doFinal(pictstream, offset + 2, 1, pictstream, offset + 2);
                this.cipher.doFinal(pictstream, offset + 3, 1, pictstream, offset + 3);
                int cbName = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 1));
                offset += 4;
                if (cbName > 0) {
                    this.cipher.doFinal(pictstream, offset, cbName, pictstream, offset);
                    offset += cbName;
                }
                if (offset == endOffset) {
                    return;
                }
                this.cipher.doFinal(pictstream, offset, 8, pictstream, offset);
                recInst = fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
                recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
                offset += 8;
            }
            int rgbUidCnt = recInst == 535 || recInst == 981 || recInst == 1131 || recInst == 1347 || recInst == 1761 || recInst == 1763 || recInst == 1765 || recInst == 1961 ? 2 : 1;
            for (int i = 0; i < rgbUidCnt; ++i) {
                this.cipher.doFinal(pictstream, offset, 16, pictstream, offset);
                offset += 16;
            }
            if (recType == 61466 || recType == 61467 || recType == 61468) {
                this.cipher.doFinal(pictstream, offset, 34, pictstream, offset);
                offset += 34;
            } else {
                this.cipher.doFinal(pictstream, offset, 1, pictstream, offset);
                ++offset;
            }
            int blipLen = endOffset - offset;
            this.cipher.doFinal(pictstream, offset, blipLen, pictstream, offset);
        }
        catch (GeneralSecurityException e) {
            throw new CorruptPowerPointFileException(e);
        }
    }

    protected void encryptPicture(byte[] pictstream, int offset) {
        if (this.dea == null) {
            return;
        }
        this.encryptInit();
        this.setPersistId(0);
        try {
            int recInst = fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
            int recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
            int rlen = (int)LittleEndian.getUInt((byte[])pictstream, (int)(offset + 4));
            this.cipher.doFinal(pictstream, offset, 8, pictstream, offset);
            int endOffset = (offset += 8) + rlen;
            if (recType == 61447) {
                this.cipher.doFinal(pictstream, offset, 1, pictstream, offset);
                this.cipher.doFinal(pictstream, ++offset, 1, pictstream, offset);
                this.cipher.doFinal(pictstream, ++offset, 16, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 16, 2, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 2, 4, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 4, 4, pictstream, offset);
                this.cipher.doFinal(pictstream, offset += 4, 4, pictstream, offset);
                int cbName = LittleEndian.getUShort((byte[])pictstream, (int)((offset += 4) + 1));
                this.cipher.doFinal(pictstream, offset + 0, 1, pictstream, offset + 0);
                this.cipher.doFinal(pictstream, offset + 1, 1, pictstream, offset + 1);
                this.cipher.doFinal(pictstream, offset + 2, 1, pictstream, offset + 2);
                this.cipher.doFinal(pictstream, offset + 3, 1, pictstream, offset + 3);
                offset += 4;
                if (cbName > 0) {
                    this.cipher.doFinal(pictstream, offset, cbName, pictstream, offset);
                    offset += cbName;
                }
                if (offset == endOffset) {
                    return;
                }
                recInst = fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
                recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
                this.cipher.doFinal(pictstream, offset, 8, pictstream, offset);
                offset += 8;
            }
            int rgbUidCnt = recInst == 535 || recInst == 981 || recInst == 1131 || recInst == 1347 || recInst == 1761 || recInst == 1763 || recInst == 1765 || recInst == 1961 ? 2 : 1;
            for (int i = 0; i < rgbUidCnt; ++i) {
                this.cipher.doFinal(pictstream, offset, 16, pictstream, offset);
                offset += 16;
            }
            if (recType == 61466 || recType == 61467 || recType == 61468) {
                this.cipher.doFinal(pictstream, offset, 34, pictstream, offset);
                offset += 34;
            } else {
                this.cipher.doFinal(pictstream, offset, 1, pictstream, offset);
                ++offset;
            }
            int blipLen = endOffset - offset;
            this.cipher.doFinal(pictstream, offset, blipLen, pictstream, offset);
        }
        catch (GeneralSecurityException e) {
            throw new CorruptPowerPointFileException(e);
        }
    }

    protected Record[] updateEncryptionRecord(Record[] records) {
        String password = Biff8EncryptionKey.getCurrentUserPassword();
        if (password == null) {
            if (this.dea == null) {
                return records;
            }
            this.dea = null;
            return HSLFSlideShowEncrypted.removeEncryptionRecord(records);
        }
        if (this.dea == null) {
            this.dea = new DocumentEncryptionAtom();
            this.enc = null;
        }
        this.encryptInit();
        EncryptionInfo ei = this.dea.getEncryptionInfo();
        byte[] salt = ei.getVerifier().getSalt();
        if (salt == null) {
            this.enc.confirmPassword(password);
        } else {
            byte[] verifier = ei.getDecryptor().getVerifier();
            this.enc.confirmPassword(password, null, null, verifier, salt, null);
        }
        records = HSLFSlideShowEncrypted.normalizeRecords(records);
        return HSLFSlideShowEncrypted.addEncryptionRecord(records, this.dea);
    }

    protected static Record[] normalizeRecords(Record[] records) {
        UserEditAtom uea = null;
        PositionDependentRecordAtom pph = null;
        TreeMap<Integer, Integer> slideLocations = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Record> recordMap = new TreeMap<Integer, Record>();
        ArrayList<Integer> obsoleteOffsets = new ArrayList<Integer>();
        int duplicatedCount = 0;
        for (Record r : records) {
            assert (r instanceof PositionDependentRecord);
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)r);
            if (pdr instanceof UserEditAtom) {
                uea = (UserEditAtom)pdr;
                continue;
            }
            if (pdr instanceof PersistPtrHolder) {
                if (pph != null) {
                    ++duplicatedCount;
                }
                pph = (PersistPtrHolder)pdr;
                for (Map.Entry<Integer, Integer> me : ((PersistPtrHolder)pph).getSlideLocationsLookup().entrySet()) {
                    Integer oldOffset = slideLocations.put(me.getKey(), me.getValue());
                    if (oldOffset == null) continue;
                    obsoleteOffsets.add(oldOffset);
                }
                continue;
            }
            recordMap.put(pdr.getLastOnDiskOffset(), r);
        }
        assert (uea != null && pph != null && uea.getPersistPointersOffset() == pph.getLastOnDiskOffset());
        recordMap.put(pph.getLastOnDiskOffset(), pph);
        recordMap.put(uea.getLastOnDiskOffset(), uea);
        if (duplicatedCount == 0 && obsoleteOffsets.isEmpty()) {
            return records;
        }
        uea.setLastUserEditAtomOffset(0);
        ((PersistPtrHolder)pph).clear();
        for (Map.Entry me : slideLocations.entrySet()) {
            ((PersistPtrHolder)pph).addSlideLookup((Integer)me.getKey(), (Integer)me.getValue());
        }
        for (Integer oldOffset : obsoleteOffsets) {
            recordMap.remove(oldOffset);
        }
        return recordMap.values().toArray(new Record[recordMap.size()]);
    }

    protected static Record[] removeEncryptionRecord(Record[] records) {
        int deaSlideId = -1;
        int deaOffset = -1;
        PersistPtrHolder ptr = null;
        UserEditAtom uea = null;
        ArrayList<Record> recordList = new ArrayList<Record>();
        for (Record r : records) {
            if (r instanceof DocumentEncryptionAtom) {
                deaOffset = ((DocumentEncryptionAtom)r).getLastOnDiskOffset();
                continue;
            }
            if (r instanceof UserEditAtom) {
                uea = (UserEditAtom)r;
                deaSlideId = uea.getEncryptSessionPersistIdRef();
                uea.setEncryptSessionPersistIdRef(-1);
            } else if (r instanceof PersistPtrHolder) {
                ptr = (PersistPtrHolder)r;
            }
            recordList.add(r);
        }
        assert (ptr != null);
        if (deaSlideId == -1 && deaOffset == -1) {
            return records;
        }
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>(ptr.getSlideLocationsLookup());
        ptr.clear();
        int maxSlideId = -1;
        for (Map.Entry<Integer, Integer> me : tm.entrySet()) {
            if (me.getKey() == deaSlideId || me.getValue() == deaOffset) continue;
            ptr.addSlideLookup(me.getKey(), me.getValue());
            maxSlideId = Math.max(me.getKey(), maxSlideId);
        }
        uea.setMaxPersistWritten(maxSlideId);
        records = recordList.toArray(new Record[recordList.size()]);
        return records;
    }

    protected static Record[] addEncryptionRecord(Record[] records, DocumentEncryptionAtom dea) {
        assert (dea != null);
        int ueaIdx = -1;
        int ptrIdx = -1;
        int deaIdx = -1;
        int idx = -1;
        for (Record r : records) {
            ++idx;
            if (r instanceof UserEditAtom) {
                ueaIdx = idx;
                continue;
            }
            if (r instanceof PersistPtrHolder) {
                ptrIdx = idx;
                continue;
            }
            if (!(r instanceof DocumentEncryptionAtom)) continue;
            deaIdx = idx;
        }
        assert (ueaIdx != -1 && ptrIdx != -1 && ptrIdx < ueaIdx);
        if (deaIdx != -1) {
            DocumentEncryptionAtom deaOld = (DocumentEncryptionAtom)records[deaIdx];
            dea.setLastOnDiskOffset(deaOld.getLastOnDiskOffset());
            records[deaIdx] = dea;
            return records;
        }
        PersistPtrHolder ptr = (PersistPtrHolder)records[ptrIdx];
        UserEditAtom uea = (UserEditAtom)records[ueaIdx];
        dea.setLastOnDiskOffset(ptr.getLastOnDiskOffset() - 1);
        int nextSlideId = uea.getMaxPersistWritten() + 1;
        ptr.addSlideLookup(nextSlideId, ptr.getLastOnDiskOffset() - 1);
        uea.setEncryptSessionPersistIdRef(nextSlideId);
        uea.setMaxPersistWritten(nextSlideId);
        Record[] newRecords = new Record[records.length + 1];
        if (ptrIdx > 0) {
            System.arraycopy(records, 0, newRecords, 0, ptrIdx);
        }
        if (ptrIdx < records.length - 1) {
            System.arraycopy(records, ptrIdx, newRecords, ptrIdx + 1, records.length - ptrIdx);
        }
        newRecords[ptrIdx] = dea;
        return newRecords;
    }
}

