/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.CustomWindowStateDD;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.SupportedWindowStateService;
import org.apache.pluto.spi.optional.PortletRegistryService;

public class SupportedWindowStateServiceImpl
implements SupportedWindowStateService {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$services$impl$resource$SupportedWindowStateServiceImpl == null ? (class$org$apache$pluto$driver$services$impl$resource$SupportedWindowStateServiceImpl = SupportedWindowStateServiceImpl.class$("org.apache.pluto.driver.services.impl.resource.SupportedWindowStateServiceImpl")) : class$org$apache$pluto$driver$services$impl$resource$SupportedWindowStateServiceImpl));
    private ServletContext servletContext = null;
    protected PropertyConfigService propertyService = null;
    protected PortletRegistryService portletRegistry = null;
    protected Set portalSupportedWindowStates = new HashSet(3);
    protected static final Set JSR168_WINDOW_STATES = new HashSet(3);
    static /* synthetic */ Class class$org$apache$pluto$driver$services$impl$resource$SupportedWindowStateServiceImpl;

    private SupportedWindowStateServiceImpl() {
    }

    public SupportedWindowStateServiceImpl(PropertyConfigService propertyService) {
        this.propertyService = propertyService;
    }

    public boolean isWindowStateSupported(String portletId, String state) {
        if (JSR168_WINDOW_STATES.contains(state)) {
            return true;
        }
        return this.isWindowStateSupportedByPortal(state) && this.isWindowStateSupportedByPortlet(portletId, state);
    }

    public boolean isWindowStateSupportedByPortal(String state) {
        return this.portalSupportedWindowStates.contains(state);
    }

    public boolean isWindowStateSupportedByPortlet(String portletId, String state) {
        if (portletId == null || state == null || portletId.trim().equals("") || state.trim().equals("")) {
            StringBuffer errMsg = new StringBuffer("Cannot determine supported window states for portletId [" + portletId + "] and window state [" + state + "].  ");
            String msg = errMsg.append("One or both of the arguments is empty or null.").toString();
            LOG.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        if (JSR168_WINDOW_STATES.contains(new WindowState(state))) {
            return true;
        }
        String appId = PortletWindowConfig.parseContextPath((String)portletId);
        PortletAppDD portletAppDD = null;
        if (this.portletRegistry == null) {
            this.portletRegistry = this.getPortletRegistryService();
            if (this.portletRegistry == null) {
                return false;
            }
        }
        try {
            portletAppDD = this.portletRegistry.getPortletApplicationDescriptor(appId);
        }
        catch (PortletContainerException e) {
            StringBuffer errMsg = new StringBuffer("Cannot determine supported window states for portletId [" + portletId + "] and window state [" + state + "].  ");
            String msg = errMsg.append("Unable to access the Portlet Registry Service.").toString();
            LOG.error((Object)msg, (Throwable)e);
        }
        List customWindowStates = portletAppDD.getCustomWindowStates();
        if (customWindowStates != null) {
            Iterator i = customWindowStates.iterator();
            while (i.hasNext()) {
                CustomWindowStateDD customState = (CustomWindowStateDD)i.next();
                if (!customState.getWindowState().equals(state)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() throws DriverConfigurationException {
        LOG.debug((Object)"Destroying SupportedWindowStateService... ");
        this.portletRegistry = null;
        this.propertyService = null;
        this.portalSupportedWindowStates = null;
        LOG.debug((Object)"SupportedWindowStateService destroyed.");
    }

    public void init(ServletContext ctx) throws DriverConfigurationException {
        CharSequence msg;
        LOG.debug((Object)"Initializing SupportedWindowStateService... ");
        this.servletContext = ctx;
        this.portalSupportedWindowStates = this.propertyService.getSupportedWindowStates();
        if (LOG.isDebugEnabled()) {
            msg = new StringBuffer();
            if (this.portalSupportedWindowStates != null) {
                ((StringBuffer)msg).append("Portal supports [" + this.portalSupportedWindowStates.size() + "] window states.  ");
                Iterator i = this.portalSupportedWindowStates.iterator();
                while (i.hasNext()) {
                    ((StringBuffer)msg).append("[" + i.next() + "]");
                    if (!i.hasNext()) continue;
                    ((StringBuffer)msg).append(", ");
                }
                LOG.debug((Object)((StringBuffer)msg).toString());
            }
        }
        if (this.portalSupportedWindowStates == null) {
            msg = "Portal supported window states is null!";
            LOG.error((Object)"Portal supported window states is null!");
            throw new DriverConfigurationException("Portal supported window states is null!");
        }
        LOG.debug((Object)"SupportedWindowStateService initialized.");
    }

    private PortletRegistryService getPortletRegistryService() {
        PortletContainer container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
        if (container == null) {
            String msg = "Unable to obtain an instance of the container.";
            LOG.fatal((Object)"Unable to obtain an instance of the container.");
            throw new NullPointerException("Unable to obtain an instance of the container.");
        }
        if (container.getOptionalContainerServices() == null || container.getOptionalContainerServices().getPortletRegistryService() == null) {
            String msg = "Unable to obtain the portlet registry.  The supported window state service cannot support custom window states.";
            LOG.info((Object)"Unable to obtain the portlet registry.  The supported window state service cannot support custom window states.");
            return null;
        }
        return container.getOptionalContainerServices().getPortletRegistryService();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JSR168_WINDOW_STATES.add(WindowState.MAXIMIZED);
        JSR168_WINDOW_STATES.add(WindowState.MINIMIZED);
        JSR168_WINDOW_STATES.add(WindowState.NORMAL);
    }
}

