/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.persistence;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;

public class CopyDoc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in, String out) throws IOException, COSVisitorException {
        FileInputStream is = null;
        OutputStream os = null;
        COSWriter writer = null;
        try {
            is = new FileInputStream(in);
            PDFParser parser = new PDFParser((InputStream)is);
            parser.parse();
            COSDocument doc = parser.getDocument();
            os = new FileOutputStream(out);
            writer = new COSWriter(os);
            writer.write(doc);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void main(String[] args) {
        CopyDoc app = new CopyDoc();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.doIt(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <output-file>");
    }
}

