/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.variant;

import java.util.ArrayList;
import org.apache.parquet.variant.Metadata;
import org.apache.parquet.variant.VariantBuilder;

public class VariantArrayBuilder
extends VariantBuilder {
    private final ArrayList<Integer> offsets = new ArrayList();
    protected long numValues = 0L;

    VariantArrayBuilder(Metadata metadata) {
        super(metadata);
    }

    long numValues() {
        return this.numValues;
    }

    ArrayList<Integer> validateAndGetOffsets() {
        if ((long)this.offsets.size() != this.numValues) {
            throw new IllegalStateException(String.format("Number of offsets (%d) do not match the number of values (%d).", this.offsets.size(), this.numValues));
        }
        this.checkMultipleNested("Cannot call endArray() while a nested object/array is still open.");
        return this.offsets;
    }

    @Override
    protected void onAppend() {
        this.checkAppendWhileNested();
        this.offsets.add(this.writePos);
        ++this.numValues;
    }

    @Override
    protected void onStartNested() {
        this.checkMultipleNested("Cannot call startObject()/startArray() without calling endObject()/endArray() first.");
        this.offsets.add(this.writePos);
        ++this.numValues;
    }
}

